/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.util.List;
import org.elasticsearch.search.facet.Facet;

public interface GeoDistanceFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "geo_distance";

    public List<Entry> entries();

    public List<Entry> getEntries();

    public static class Entry {
        double from = Double.NEGATIVE_INFINITY;
        double to = Double.POSITIVE_INFINITY;
        long count;
        double total;

        Entry() {
        }

        public Entry(double from, double to, long count, double total) {
            this.from = from;
            this.to = to;
            this.count = count;
            this.total = total;
        }

        public double from() {
            return this.from;
        }

        public double getFrom() {
            return this.from();
        }

        public double to() {
            return this.to;
        }

        public double getTo() {
            return this.to();
        }

        public long count() {
            return this.count;
        }

        public long getCount() {
            return this.count();
        }

        public double total() {
            return this.total;
        }

        public double getTotal() {
            return this.total();
        }

        public double mean() {
            return this.total / (double)this.count;
        }

        public double getMean() {
            return this.mean();
        }
    }
}

