/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.trove.map.hash.TLongDoubleHashMap;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.histogram.CountAndTotalHistogramFacetCollector;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalCountAndTotalHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class KeyValueHistogramFacetCollector
extends AbstractFacetCollector {
    private final String keyIndexFieldName;
    private final String valueIndexFieldName;
    private final long interval;
    private final HistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType keyFieldDataType;
    private NumericFieldData keyFieldData;
    private final FieldDataType valueFieldDataType;
    private NumericFieldData valueFieldData;
    private final TLongLongHashMap counts = new TLongLongHashMap();
    private final TLongDoubleHashMap totals = new TLongDoubleHashMap();

    public KeyValueHistogramFacetCollector(String facetName, String keyFieldName, String valueFieldName, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.interval = interval;
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(keyFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + keyFieldName + "]");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.keyIndexFieldName = smartMappers.mapper().names().indexName();
        this.keyFieldDataType = smartMappers.mapper().fieldDataType();
        FieldMapper mapper = context.mapperService().smartNameFieldMapper(valueFieldName);
        if (mapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for value_field [" + valueFieldName + "]");
        }
        this.valueIndexFieldName = mapper.names().indexName();
        this.valueFieldDataType = mapper.fieldDataType();
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        if (this.keyFieldData.multiValued()) {
            if (this.valueFieldData.multiValued()) {
                double[] keys = this.keyFieldData.doubleValues(doc);
                double[] values = this.valueFieldData.doubleValues(doc);
                int size = Math.min(keys.length, values.length);
                for (int i = 0; i < size; ++i) {
                    long bucket = CountAndTotalHistogramFacetCollector.bucket(keys[i], this.interval);
                    this.counts.adjustOrPutValue(bucket, 1L, 1L);
                    this.totals.adjustOrPutValue(bucket, values[i], values[i]);
                }
            } else {
                double value = this.valueFieldData.doubleValue(doc);
                for (double key : this.keyFieldData.doubleValues(doc)) {
                    long bucket = CountAndTotalHistogramFacetCollector.bucket(key, this.interval);
                    this.counts.adjustOrPutValue(bucket, 1L, 1L);
                    this.totals.adjustOrPutValue(bucket, value, value);
                }
            }
        } else {
            long bucket = CountAndTotalHistogramFacetCollector.bucket(this.keyFieldData.doubleValue(doc), this.interval);
            if (this.valueFieldData.multiValued()) {
                for (double value : this.valueFieldData.doubleValues(doc)) {
                    this.counts.adjustOrPutValue(bucket, 1L, 1L);
                    this.totals.adjustOrPutValue(bucket, value, value);
                }
            } else {
                double value = this.valueFieldData.doubleValue(doc);
                this.counts.adjustOrPutValue(bucket, 1L, 1L);
                this.totals.adjustOrPutValue(bucket, value, value);
            }
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyFieldData = (NumericFieldData)this.fieldDataCache.cache(this.keyFieldDataType, reader, this.keyIndexFieldName);
        this.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.valueIndexFieldName);
    }

    @Override
    public Facet facet() {
        return new InternalCountAndTotalHistogramFacet(this.facetName, this.comparatorType, this.counts, this.totals);
    }
}

