/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class StatisticalFacetCollector
extends AbstractFacetCollector {
    private final String indexFieldName;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType fieldDataType;
    private NumericFieldData fieldData;
    private final StatsProc statsProc = new StatsProc();

    public StatisticalFacetCollector(String facetName, String fieldName, SearchContext context) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldName + "]");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
        this.fieldDataType = smartMappers.mapper().fieldDataType();
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.statsProc);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (NumericFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
    }

    @Override
    public Facet facet() {
        return new InternalStatisticalFacet(this.facetName, this.statsProc.min(), this.statsProc.max(), this.statsProc.total(), this.statsProc.sumOfSquares(), this.statsProc.count());
    }

    public static class StatsProc
    implements NumericFieldData.DoubleValueInDocProc {
        private double min = Double.NaN;
        private double max = Double.NaN;
        private double total = 0.0;
        private double sumOfSquares = 0.0;
        private long count;
        private int missing;

        @Override
        public void onValue(int docId, double value) {
            if (value < this.min || Double.isNaN(this.min)) {
                this.min = value;
            }
            if (value > this.max || Double.isNaN(this.max)) {
                this.max = value;
            }
            this.sumOfSquares += value * value;
            this.total += value;
            ++this.count;
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final double min() {
            return this.min;
        }

        public final double max() {
            return this.max;
        }

        public final double total() {
            return this.total;
        }

        public final long count() {
            return this.count;
        }

        public final double sumOfSquares() {
            return this.sumOfSquares;
        }
    }
}

