/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.jpa.Model;
import play.modules.elasticsearch.ElasticSearchAdapter;
import play.modules.elasticsearch.ElasticSearchable;
import play.mvc.Router;

public class ElasticSearchPlugin
extends PlayPlugin {
    private ThreadLocal<Client> _session = new ThreadLocal();
    private static boolean started = false;
    private static Map<Class<?>, Boolean> modelIndex = null;

    public Client client() {
        return this._session.get();
    }

    public void onApplicationStart() {
        modelIndex = new HashMap();
        if (this._session.get() != null || started) {
            Logger.debug((String)"Elastic Search Started Already!", (Object[])new Object[0]);
            return;
        }
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        settings.build();
        NodeBuilder nb = NodeBuilder.nodeBuilder().settings((Settings.Builder)settings);
        boolean localMode = false;
        if (!Play.configuration.containsKey("elasticsearch.local")) {
            localMode = Boolean.getBoolean(Play.configuration.getProperty("elasticsearch.local"));
            nb = nb.local(localMode);
        }
        boolean clientMode = false;
        if (!Play.configuration.containsKey("elasticsearch.client")) {
            clientMode = Boolean.getBoolean(Play.configuration.getProperty("elasticsearch.client"));
            nb = nb.client(clientMode);
        }
        if (!localMode && !clientMode) {
            localMode = true;
            nb = nb.local(localMode);
        }
        if (localMode) {
            Logger.info((String)"Starting Elastic Search for Play! in Local Mode", (Object[])new Object[0]);
        } else {
            Logger.info((String)"Connecting Play! to Elastic Search in Client Mode", (Object[])new Object[0]);
        }
        started = true;
        Node node = nb.node();
        Client client = node.client();
        Router.addRoute((String)"GET", (String)"/es-admin/", (String)"ElasticSearchAdmin.index");
        Router.addRoute((String)"GET", (String)"/es-admin/lib", (String)"staticDir:public");
        this._session.set(client);
    }

    private boolean isElasticSearchable(Object o) {
        for (Annotation a : o.getClass().getAnnotations()) {
            if (!ElasticSearchable.class.equals(a.getClass())) continue;
            return true;
        }
        return false;
    }

    public void onEvent(String message, Object context) {
        if (!StringUtils.startsWith((String)message, (String)"JPASupport.")) {
            return;
        }
        if (!this.isElasticSearchable(context)) {
            return;
        }
        ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
        Class<?> clazz = context.getClass();
        if (!modelIndex.containsKey(clazz)) {
            Logger.info((String)"Start Index for Class: %s", (Object[])new Object[]{clazz});
            ElasticSearchAdapter.startIndex(plugin.client(), clazz);
        }
        try {
            if (message.equals("JPASupport.objectPersisted") || message.equals("JPASupport.objectUpdated")) {
                ElasticSearchAdapter.indexModel(plugin.client(), (Model)context);
            } else if (message.equals("JPASupport.objectDeleted")) {
                ElasticSearchAdapter.deleteModel(plugin.client(), (Model)context);
            }
            Logger.debug((String)"Elastic Event Done!", (Object[])new Object[0]);
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Problem updating entity %s on event %s with error %s", (Object[])new Object[]{context, message, e.getMessage()});
        }
    }
}

