/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.impl;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.BaseMapper;
import org.codehaus.jackson.map.JsonNode;
import org.codehaus.jackson.map.node.ArrayNode;
import org.codehaus.jackson.map.node.BooleanNode;
import org.codehaus.jackson.map.node.DecimalNode;
import org.codehaus.jackson.map.node.DoubleNode;
import org.codehaus.jackson.map.node.IntNode;
import org.codehaus.jackson.map.node.LongNode;
import org.codehaus.jackson.map.node.NullNode;
import org.codehaus.jackson.map.node.NumericNode;
import org.codehaus.jackson.map.node.ObjectNode;
import org.codehaus.jackson.map.node.TextNode;

public abstract class JsonTypeMapperBase
extends BaseMapper {
    protected JsonTypeMapperBase() {
    }

    public ArrayNode arrayNode() {
        return new ArrayNode();
    }

    public ObjectNode objectNode() {
        return new ObjectNode();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    public NumericNode numberNode(long v) {
        return LongNode.valueOf(v);
    }

    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    public NumericNode numberNode(BigDecimal v) {
        return DecimalNode.valueOf(v);
    }

    protected JsonNode readAndMap(JsonParser jp, JsonToken currToken) throws IOException, JsonParseException {
        switch (currToken) {
            case START_OBJECT: {
                ObjectNode node = this.objectNode();
                while ((currToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                    if (currToken != JsonToken.FIELD_NAME) {
                        this._reportProblem(jp, "Unexpected token (" + (Object)((Object)currToken) + "), expected FIELD_NAME");
                    }
                    String fieldName = jp.getText();
                    JsonNode value = this.readAndMap(jp, jp.nextToken());
                    if (this._cfgDupFields == BaseMapper.DupFields.ERROR) {
                        JsonNode old = node.setElement(fieldName, value);
                        if (old == null) continue;
                        this._reportProblem(jp, "Duplicate value for field '" + fieldName + "', when dup fields mode is " + (Object)((Object)this._cfgDupFields));
                        continue;
                    }
                    if (this._cfgDupFields == BaseMapper.DupFields.USE_LAST) {
                        node.setElement(fieldName, value);
                        continue;
                    }
                    if (node.getFieldValue(fieldName) != null) continue;
                    node.setElement(fieldName, value);
                }
                return node;
            }
            case START_ARRAY: {
                ArrayNode node = this.arrayNode();
                while ((currToken = jp.nextToken()) != JsonToken.END_ARRAY) {
                    JsonNode value = this.readAndMap(jp, currToken);
                    node.appendElement(value);
                }
                return node;
            }
            case VALUE_STRING: {
                return this.textNode(jp.getText());
            }
            case VALUE_NUMBER_INT: {
                if (jp.getNumberType() == JsonParser.NumberType.INT) {
                    return this.numberNode(jp.getIntValue());
                }
                return this.numberNode(jp.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                if (jp.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                    return this.numberNode(jp.getDecimalValue());
                }
                return this.numberNode(jp.getDoubleValue());
            }
            case VALUE_TRUE: {
                return this.booleanNode(true);
            }
            case VALUE_FALSE: {
                return this.booleanNode(false);
            }
            case VALUE_NULL: {
                return this.nullNode();
            }
            case FIELD_NAME: 
            case END_OBJECT: 
            case END_ARRAY: {
                this._reportProblem(jp, "Can not map token " + (Object)((Object)currToken) + ": stream off by a token or two?");
            }
        }
        this._throwInternal("Unrecognized event type: " + (Object)((Object)currToken));
        return null;
    }
}

