/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.legacy;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;

final class KnownClasses {
    static final HashMap<String, JdkClasses> mConcrete = new HashMap();

    KnownClasses() {
    }

    public static final JdkClasses findTypeFast(Object value) {
        return mConcrete.get(value.getClass().getName());
    }

    public static final JdkClasses findTypeSlow(Object value) {
        if (value instanceof Map) {
            return JdkClasses.MAP;
        }
        if (value instanceof Object[]) {
            return JdkClasses.ARRAY_OBJECT;
        }
        if (value instanceof List) {
            return JdkClasses.LIST_OTHER;
        }
        if (value instanceof Collection) {
            return JdkClasses.LIST_OTHER;
        }
        if (value instanceof CharSequence) {
            return JdkClasses.STRING_LIKE;
        }
        if (value instanceof Number) {
            return JdkClasses.NUMBER_OTHER;
        }
        if (value instanceof Iterable) {
            return JdkClasses.ITERABLE;
        }
        if (value instanceof Iterator) {
            return JdkClasses.ITERATOR;
        }
        return null;
    }

    static {
        mConcrete.put(Boolean.class.getName(), JdkClasses.BOOLEAN);
        mConcrete.put(String.class.getName(), JdkClasses.STRING);
        mConcrete.put(StringBuffer.class.getName(), JdkClasses.STRING_LIKE);
        mConcrete.put(StringBuilder.class.getName(), JdkClasses.STRING_LIKE);
        mConcrete.put(Character.class.getName(), JdkClasses.STRING_LIKE);
        mConcrete.put(UUID.class.getName(), JdkClasses.STRING_LIKE);
        mConcrete.put(new long[0].getClass().getName(), JdkClasses.ARRAY_LONG);
        mConcrete.put(new int[0].getClass().getName(), JdkClasses.ARRAY_INT);
        mConcrete.put(new short[0].getClass().getName(), JdkClasses.ARRAY_SHORT);
        mConcrete.put(new char[0].getClass().getName(), JdkClasses.ARRAY_CHAR);
        mConcrete.put(new byte[0].getClass().getName(), JdkClasses.ARRAY_BYTE);
        mConcrete.put(new double[0].getClass().getName(), JdkClasses.ARRAY_DOUBLE);
        mConcrete.put(new float[0].getClass().getName(), JdkClasses.ARRAY_FLOAT);
        mConcrete.put(new boolean[0].getClass().getName(), JdkClasses.ARRAY_BOOLEAN);
        mConcrete.put(new Object[0].getClass().getName(), JdkClasses.ARRAY_OBJECT);
        mConcrete.put(new String[0].getClass().getName(), JdkClasses.ARRAY_OBJECT);
        mConcrete.put(Byte.class.getName(), JdkClasses.NUMBER_INTEGER);
        mConcrete.put(Short.class.getName(), JdkClasses.NUMBER_INTEGER);
        mConcrete.put(Integer.class.getName(), JdkClasses.NUMBER_INTEGER);
        mConcrete.put(Long.class.getName(), JdkClasses.NUMBER_LONG);
        mConcrete.put(Float.class.getName(), JdkClasses.NUMBER_DOUBLE);
        mConcrete.put(Double.class.getName(), JdkClasses.NUMBER_DOUBLE);
        mConcrete.put(BigInteger.class.getName(), JdkClasses.NUMBER_OTHER);
        mConcrete.put(BigDecimal.class.getName(), JdkClasses.NUMBER_OTHER);
        mConcrete.put(HashMap.class.getName(), JdkClasses.MAP);
        mConcrete.put(Hashtable.class.getName(), JdkClasses.MAP);
        mConcrete.put(LinkedHashMap.class.getName(), JdkClasses.MAP);
        mConcrete.put(TreeMap.class.getName(), JdkClasses.MAP);
        mConcrete.put(EnumMap.class.getName(), JdkClasses.MAP);
        mConcrete.put(Properties.class.getName(), JdkClasses.MAP);
        mConcrete.put(ArrayList.class.getName(), JdkClasses.LIST_INDEXED);
        mConcrete.put(Vector.class.getName(), JdkClasses.LIST_INDEXED);
        mConcrete.put(LinkedList.class.getName(), JdkClasses.LIST_OTHER);
        mConcrete.put(HashSet.class.getName(), JdkClasses.COLLECTION);
        mConcrete.put(LinkedHashSet.class.getName(), JdkClasses.COLLECTION);
        mConcrete.put(TreeSet.class.getName(), JdkClasses.COLLECTION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JdkClasses {
        BOOLEAN,
        STRING,
        STRING_LIKE,
        NUMBER_INTEGER,
        NUMBER_LONG,
        NUMBER_DOUBLE,
        NUMBER_OTHER,
        ARRAY_LONG,
        ARRAY_INT,
        ARRAY_SHORT,
        ARRAY_CHAR,
        ARRAY_BYTE,
        ARRAY_DOUBLE,
        ARRAY_FLOAT,
        ARRAY_BOOLEAN,
        ARRAY_OBJECT,
        MAP,
        LIST_INDEXED,
        LIST_OTHER,
        COLLECTION,
        ITERABLE,
        ITERATOR;

    }
}

