/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializable;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.JsonSerializerFactory;
import org.codehaus.jackson.map.JsonSerializerProvider;
import org.codehaus.jackson.map.ser.ToStringSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdSerializerFactory
extends JsonSerializerFactory {
    static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    public static final StdSerializerFactory instance;

    protected StdSerializerFactory() {
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type) {
        JsonSerializer<?> ser = this.findSerializerByLookup(type);
        if (ser == null && (ser = this.findSerializerByPrimaryType(type)) == null) {
            ser = this.findSerializerByAddonType(type);
        }
        return ser;
    }

    public final JsonSerializer<?> getNullSerializer() {
        return NullSerializer.instance;
    }

    public final JsonSerializer<?> findSerializerByLookup(Class<?> type) {
        return _concrete.get(type.getName());
    }

    public final JsonSerializer<?> findSerializerByPrimaryType(Class<?> type) {
        if (JsonSerializable.class.isAssignableFrom(type)) {
            return SerializableSerializer.instance;
        }
        if (Map.class.isAssignableFrom(type)) {
            return MapSerializer.instance;
        }
        if (Object[].class.isAssignableFrom(type)) {
            return ObjectArraySerializer.instance;
        }
        if (List.class.isAssignableFrom(type)) {
            if (RandomAccess.class.isAssignableFrom(type)) {
                return IndexedListSerializer.instance;
            }
            return CollectionSerializer.instance;
        }
        if (Number.class.isAssignableFrom(type)) {
            return NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return new EnumSerializer();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return CollectionSerializer.instance;
        }
        return null;
    }

    public final JsonSerializer<?> findSerializerByAddonType(Class<?> type) {
        if (Iterator.class.isAssignableFrom(type)) {
            return new IteratorSerializer();
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return new IterableSerializer();
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return StringLikeSerializer.instance;
        }
        return null;
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), sls);
        _concrete.put(StringBuilder.class.getName(), sls);
        _concrete.put(Character.class.getName(), sls);
        _concrete.put(UUID.class.getName(), sls);
        _concrete.put(Boolean.class.getName(), BooleanSerializer.instance);
        _concrete.put(Boolean.TYPE.getName(), BooleanSerializer.instance);
        IntegerSerializer intS = new IntegerSerializer();
        _concrete.put(Byte.class.getName(), intS);
        _concrete.put(Byte.TYPE.getName(), intS);
        _concrete.put(Short.class.getName(), intS);
        _concrete.put(Short.TYPE.getName(), intS);
        _concrete.put(Integer.class.getName(), intS);
        _concrete.put(Integer.TYPE.getName(), intS);
        _concrete.put(Long.class.getName(), LongSerializer.instance);
        _concrete.put(Long.TYPE.getName(), LongSerializer.instance);
        _concrete.put(Float.class.getName(), FloatSerializer.instance);
        _concrete.put(Float.TYPE.getName(), FloatSerializer.instance);
        _concrete.put(Double.class.getName(), DoubleSerializer.instance);
        _concrete.put(Double.TYPE.getName(), DoubleSerializer.instance);
        NumberSerializer ns = new NumberSerializer();
        _concrete.put(BigInteger.class.getName(), ns);
        _concrete.put(BigDecimal.class.getName(), ns);
        _concrete.put(boolean[].class.getName(), new BooleanArraySerializer());
        _concrete.put(byte[].class.getName(), new ByteArraySerializer());
        _concrete.put(char[].class.getName(), new CharArraySerializer());
        _concrete.put(short[].class.getName(), new ShortArraySerializer());
        _concrete.put(int[].class.getName(), new IntArraySerializer());
        _concrete.put(long[].class.getName(), new LongArraySerializer());
        _concrete.put(float[].class.getName(), new FloatArraySerializer());
        _concrete.put(double[].class.getName(), new DoubleArraySerializer());
        _concrete.put(Object[].class.getName(), ObjectArraySerializer.instance);
        _concrete.put(String[].class.getName(), new StringArraySerializer());
        IndexedListSerializer indListS = IndexedListSerializer.instance;
        CollectionSerializer collectionS = CollectionSerializer.instance;
        _concrete.put(ArrayList.class.getName(), indListS);
        _concrete.put(Vector.class.getName(), indListS);
        _concrete.put(LinkedList.class.getName(), collectionS);
        MapSerializer mapS = MapSerializer.instance;
        _concrete.put(HashMap.class.getName(), mapS);
        _concrete.put(Hashtable.class.getName(), mapS);
        _concrete.put(LinkedHashMap.class.getName(), mapS);
        _concrete.put(TreeMap.class.getName(), mapS);
        _concrete.put(Properties.class.getName(), mapS);
        _concrete.put(HashSet.class.getName(), collectionS);
        _concrete.put(LinkedHashSet.class.getName(), collectionS);
        _concrete.put(TreeSet.class.getName(), collectionS);
        _concrete.put(EnumMap.class.getName(), new EnumMapSerializer());
        _concrete.put(EnumSet.class.getName(), new EnumSetSerializer());
        NullSerializer nullS = NullSerializer.instance;
        _concrete.put(Void.TYPE.getName(), nullS);
        instance = new StdSerializerFactory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SerializableSerializer
    extends JsonSerializer<JsonSerializable> {
        static final SerializableSerializer instance = new SerializableSerializer();

        private SerializableSerializer() {
        }

        @Override
        public void serialize(JsonSerializable value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            value.serialize(jgen, provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NullSerializer
    extends JsonSerializer<Object> {
        static final NullSerializer instance = new NullSerializer();

        private NullSerializer() {
        }

        @Override
        public void serialize(Object value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeNull();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumSerializer
    extends JsonSerializer<Enum<?>> {
        @Override
        public void serialize(Enum<?> value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value.name());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoubleArraySerializer
    extends JsonSerializer<double[]> {
        @Override
        public void serialize(double[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FloatArraySerializer
    extends JsonSerializer<float[]> {
        @Override
        public void serialize(float[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongArraySerializer
    extends JsonSerializer<long[]> {
        @Override
        public void serialize(long[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntArraySerializer
    extends JsonSerializer<int[]> {
        @Override
        public void serialize(int[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CharArraySerializer
    extends JsonSerializer<char[]> {
        @Override
        public void serialize(char[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value, 0, value.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ShortArraySerializer
    extends JsonSerializer<short[]> {
        @Override
        public void serialize(short[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        @Override
        public void serialize(byte[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeBinary(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BooleanArraySerializer
    extends JsonSerializer<boolean[]> {
        @Override
        public void serialize(boolean[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeBoolean(value[i]);
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringArraySerializer
    extends JsonSerializer<String[]> {
        @Override
        public void serialize(String[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    jgen.writeString(value[i]);
                }
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObjectArraySerializer
    extends JsonSerializer<Object[]> {
        public static final ObjectArraySerializer instance = new ObjectArraySerializer();

        @Override
        public void serialize(Object[] value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            if (len > 0) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                for (int i = 0; i < len; ++i) {
                    JsonSerializer<Object> currSerializer;
                    Object elem = value[i];
                    if (elem == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                }
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumMapSerializer
    extends JsonSerializer<EnumMap<? extends Enum<?>, ?>> {
        @Override
        public void serialize(EnumMap<? extends Enum<?>, ?> value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            JsonSerializer<Object> prevSerializer = null;
            Class<?> prevClass = null;
            for (Map.Entry<Enum<?>, ?> entry : value.entrySet()) {
                JsonSerializer<Object> currSerializer;
                jgen.writeFieldName(entry.getKey().name());
                Enum<?> valueElem = entry.getKey();
                if (valueElem == null) {
                    provider.getNullValueSerializer().serialize(null, jgen, provider);
                    continue;
                }
                Class<?> cc = valueElem.getClass();
                if (cc == prevClass) {
                    currSerializer = prevSerializer;
                } else {
                    prevSerializer = currSerializer = provider.findValueSerializer(cc);
                    prevClass = cc;
                }
                currSerializer.serialize(valueElem, jgen, provider);
            }
            jgen.writeEndObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MapSerializer
    extends JsonSerializer<Map<?, ?>> {
        public static final MapSerializer instance = new MapSerializer();

        @Override
        public void serialize(Map<?, ?> value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            int len = value.size();
            if (len > 0) {
                JsonSerializer<Object> keySerializer = provider.getKeySerializer();
                JsonSerializer<Object> prevValueSerializer = null;
                Class<?> prevValueClass = null;
                for (Map.Entry<?, ?> entry : value.entrySet()) {
                    JsonSerializer<Object> currSerializer;
                    Object keyElem = entry.getKey();
                    if (keyElem == null) {
                        provider.getNullKeySerializer().serialize(null, jgen, provider);
                    } else {
                        keySerializer.serialize(keyElem, jgen, provider);
                    }
                    Object valueElem = entry.getValue();
                    if (valueElem == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = valueElem.getClass();
                    if (cc == prevValueClass) {
                        currSerializer = prevValueSerializer;
                    } else {
                        prevValueSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevValueClass = cc;
                    }
                    currSerializer.serialize(valueElem, jgen, provider);
                }
            }
            jgen.writeEndObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumSetSerializer
    extends JsonSerializer<EnumSet<? extends Enum<?>>> {
        public static final CollectionSerializer instance = new CollectionSerializer();

        @Override
        public void serialize(EnumSet<? extends Enum<?>> value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            for (Enum enum_ : value) {
                jgen.writeString(enum_.name());
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IterableSerializer
    extends JsonSerializer<Iterable<?>> {
        @Override
        public void serialize(Iterable<?> value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = it.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (it.hasNext());
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IteratorSerializer
    extends JsonSerializer<Iterator<?>> {
        @Override
        public void serialize(Iterator<?> value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            if (value.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = value.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (value.hasNext());
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CollectionSerializer
    extends JsonSerializer<Collection<?>> {
        public static final CollectionSerializer instance = new CollectionSerializer();

        @Override
        public void serialize(Collection<?> value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = it.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (it.hasNext());
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IndexedListSerializer
    extends JsonSerializer<List<?>> {
        public static final IndexedListSerializer instance = new IndexedListSerializer();

        @Override
        public void serialize(List<?> value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.size();
            if (len > 0) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                for (int i = 0; i < len; ++i) {
                    JsonSerializer<Object> currSerializer;
                    Object elem = value.get(i);
                    if (elem == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                }
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NumberSerializer
    extends JsonSerializer<Number> {
        public static final NumberSerializer instance = new NumberSerializer();

        @Override
        public void serialize(Number value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeNumber(value.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoubleSerializer
    extends JsonSerializer<Double> {
        static final DoubleSerializer instance = new DoubleSerializer();

        @Override
        public void serialize(Double value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeNumber(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FloatSerializer
    extends JsonSerializer<Float> {
        static final FloatSerializer instance = new FloatSerializer();

        @Override
        public void serialize(Float value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeNumber(value.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongSerializer
    extends JsonSerializer<Long> {
        static final LongSerializer instance = new LongSerializer();

        @Override
        public void serialize(Long value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeNumber(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntegerSerializer
    extends JsonSerializer<Integer> {
        @Override
        public void serialize(Integer value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeNumber(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringLikeSerializer
    extends JsonSerializer<Object> {
        public static final StringLikeSerializer instance = new StringLikeSerializer();

        @Override
        public void serialize(Object value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringSerializer
    extends JsonSerializer<String> {
        @Override
        public void serialize(String value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BooleanSerializer
    extends JsonSerializer<Boolean> {
        static final BooleanSerializer instance = new BooleanSerializer();

        @Override
        public void serialize(Boolean value, JsonGenerator jgen, JsonSerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeBoolean(value);
        }
    }
}

