/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ExistsFieldQueryExtension;
import org.apache.lucene.queryParser.FieldQueryExtension;
import org.apache.lucene.queryParser.MissingFieldQueryExtension;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;

public class MapperQueryParser
extends QueryParser {
    public static final ImmutableMap<String, FieldQueryExtension> fieldQueryExtensions = ImmutableMap.builder().put("_exists_", new ExistsFieldQueryExtension()).put("_missing_", (ExistsFieldQueryExtension)((Object)new MissingFieldQueryExtension())).build();
    private final QueryParseContext parseContext;
    private FieldMapper currentMapper;

    public MapperQueryParser(QueryParseContext parseContext) {
        super(Lucene.QUERYPARSER_VERSION, null, null);
        this.parseContext = parseContext;
    }

    public MapperQueryParser(QueryParserSettings settings, QueryParseContext parseContext) {
        super(Lucene.QUERYPARSER_VERSION, settings.defaultField(), settings.analyzer());
        this.parseContext = parseContext;
        this.reset(settings);
    }

    public void reset(QueryParserSettings settings) {
        this.field = settings.defaultField();
        this.analyzer = settings.analyzer();
        this.setMultiTermRewriteMethod(MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
        this.setEnablePositionIncrements(settings.enablePositionIncrements());
        this.setAllowLeadingWildcard(settings.allowLeadingWildcard());
        this.setLowercaseExpandedTerms(settings.lowercaseExpandedTerms());
        this.setPhraseSlop(settings.phraseSlop());
        this.setDefaultOperator(settings.defaultOperator());
        this.setFuzzyMinSim(settings.fuzzyMinSim());
        this.setFuzzyPrefixLength(settings.fuzzyPrefixLength());
    }

    protected Query newTermQuery(Term term) {
        Query termQuery;
        if (this.currentMapper != null && (termQuery = this.currentMapper.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return super.newTermQuery(term);
    }

    protected Query newMatchAllDocsQuery() {
        return Queries.MATCH_ALL_QUERY;
    }

    public Query getFieldQuery(String field, String queryText) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        FieldQueryExtension fieldQueryExtension = fieldQueryExtensions.get(field);
        if (fieldQueryExtension != null) {
            return fieldQueryExtension.query(this.parseContext, queryText);
        }
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                Query query = null;
                if (this.currentMapper.useFieldQueryWithQueryString()) {
                    query = this.currentMapper.fieldQuery(queryText);
                }
                if (query == null) {
                    query = super.getFieldQuery(this.currentMapper.names().indexName(), queryText);
                }
                return QueryParsers.wrapSmartNameQuery(query, fieldMappers, this.parseContext);
            }
        }
        return super.getFieldQuery(field, queryText);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        if ("*".equals(part1)) {
            part1 = null;
        }
        if ("*".equals(part2)) {
            part2 = null;
        }
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                Query rangeQuery = this.currentMapper.rangeQuery(part1, part2, inclusive, inclusive);
                return QueryParsers.wrapSmartNameQuery(rangeQuery, fieldMappers, this.parseContext);
            }
        }
        return this.newRangeQuery(field, part1, part2, inclusive);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        String indexedNameField = field;
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                indexedNameField = this.currentMapper.names().indexName();
            }
            return QueryParsers.wrapSmartNameQuery(super.getPrefixQuery(indexedNameField, termStr), fieldMappers, this.parseContext);
        }
        return super.getPrefixQuery(indexedNameField, termStr);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        String indexedNameField = field;
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                indexedNameField = this.currentMapper.names().indexName();
            }
            return QueryParsers.wrapSmartNameQuery(super.getFuzzyQuery(indexedNameField, termStr, minSimilarity), fieldMappers, this.parseContext);
        }
        return super.getFuzzyQuery(indexedNameField, termStr, minSimilarity);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        if ("_all".equals(field) && termStr.equals("*")) {
            return this.newMatchAllDocsQuery();
        }
        String indexedNameField = field;
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                indexedNameField = this.currentMapper.names().indexName();
            }
            return QueryParsers.wrapSmartNameQuery(super.getWildcardQuery(indexedNameField, termStr), fieldMappers, this.parseContext);
        }
        return super.getWildcardQuery(indexedNameField, termStr);
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses, boolean disableCoord) throws ParseException {
        Query q = super.getBooleanQuery(clauses, disableCoord);
        if (q == null) {
            return null;
        }
        return Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(q));
    }

    protected FieldMapper fieldMapper(String smartName) {
        if (this.parseContext.mapperService() == null) {
            return null;
        }
        FieldMappers fieldMappers = this.parseContext.mapperService().smartNameFieldMappers(smartName);
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }
}

