/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class NodesShutdownRequest
extends MasterNodeOperationRequest {
    String[] nodesIds = Strings.EMPTY_ARRAY;
    TimeValue delay = TimeValue.timeValueSeconds(1L);

    NodesShutdownRequest() {
    }

    public NodesShutdownRequest(String ... nodesIds) {
        this.nodesIds = nodesIds;
    }

    public NodesShutdownRequest nodesIds(String ... nodesIds) {
        this.nodesIds = nodesIds;
        return this;
    }

    public NodesShutdownRequest delay(TimeValue delay) {
        this.delay = delay;
        return this;
    }

    public TimeValue delay() {
        return this.delay;
    }

    public NodesShutdownRequest delay(String delay) {
        return this.delay(TimeValue.parseTimeValue(delay, null));
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.delay = TimeValue.readTimeValue(in);
        int size = in.readVInt();
        if (size > 0) {
            this.nodesIds = new String[size];
            for (int i = 0; i < this.nodesIds.length; ++i) {
                this.nodesIds[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.delay.writeTo(out);
        if (this.nodesIds == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.nodesIds.length);
            for (String nodeId : this.nodesIds) {
                out.writeUTF(nodeId);
            }
        }
    }
}

