/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.ping.replication;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class IndexReplicationPingResponse
implements ActionResponse,
Streamable {
    private String index;
    private int successfulShards;
    private int failedShards;

    IndexReplicationPingResponse(String index, int successfulShards, int failedShards) {
        this.index = index;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
    }

    IndexReplicationPingResponse() {
    }

    public String index() {
        return this.index;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public int failedShards() {
        return this.failedShards;
    }

    public int totalShards() {
        return this.successfulShards + this.failedShards;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readUTF();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.index);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
    }
}

