/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteIndexRequest
extends MasterNodeOperationRequest {
    private String index;
    private TimeValue timeout = TimeValue.timeValueSeconds(10L);

    DeleteIndexRequest() {
    }

    public DeleteIndexRequest(String index) {
        this.index = index;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = Actions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    String index() {
        return this.index;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public DeleteIndexRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public DeleteIndexRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readUTF();
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.index);
        this.timeout.writeTo(out);
    }
}

