/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.delete;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaDataDeleteIndexService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteIndexAction
extends TransportMasterNodeOperationAction<DeleteIndexRequest, DeleteIndexResponse> {
    private final MetaDataDeleteIndexService deleteIndexService;

    @Inject
    public TransportDeleteIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataDeleteIndexService deleteIndexService) {
        super(settings, transportService, clusterService, threadPool);
        this.deleteIndexService = deleteIndexService;
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected String transportAction() {
        return "indices/deleteIndex";
    }

    @Override
    protected DeleteIndexRequest newRequest() {
        return new DeleteIndexRequest();
    }

    @Override
    protected DeleteIndexResponse newResponse() {
        return new DeleteIndexResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteIndexRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA, request.index());
    }

    @Override
    protected DeleteIndexResponse masterOperation(DeleteIndexRequest request, ClusterState state) throws ElasticSearchException {
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference<InterruptedException> failureRef = new AtomicReference<InterruptedException>();
        final CountDownLatch latch = new CountDownLatch(1);
        this.deleteIndexService.deleteIndex(new MetaDataDeleteIndexService.Request(request.index()).timeout(request.timeout()), new MetaDataDeleteIndexService.Listener(){

            @Override
            public void onResponse(MetaDataDeleteIndexService.Response response) {
                responseRef.set(new DeleteIndexResponse(response.acknowledged()));
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable t) {
                failureRef.set(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failureRef.set(e);
        }
        if (failureRef.get() != null) {
            if (failureRef.get() instanceof ElasticSearchException) {
                throw (ElasticSearchException)failureRef.get();
            }
            throw new ElasticSearchException(((Throwable)failureRef.get()).getMessage(), (Throwable)failureRef.get());
        }
        return (DeleteIndexResponse)responseRef.get();
    }
}

