/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteRequest
extends ShardReplicationOperationRequest {
    private String type;
    private String id;
    @Nullable
    private String routing;
    private boolean refresh;
    private long version;

    public DeleteRequest(String index) {
        this.index = index;
    }

    public DeleteRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    public DeleteRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = Actions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = Actions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    @Override
    public DeleteRequest index(String index) {
        super.index(index);
        return this;
    }

    @Override
    public DeleteRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    @Override
    public DeleteRequest operationThreaded(boolean threadedOperation) {
        super.operationThreaded(threadedOperation);
        return this;
    }

    @Override
    public DeleteRequest replicationType(ReplicationType replicationType) {
        super.replicationType(replicationType);
        return this;
    }

    @Override
    public DeleteRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        super.consistencyLevel(consistencyLevel);
        return this;
    }

    public String type() {
        return this.type;
    }

    @Required
    public DeleteRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    @Required
    public DeleteRequest id(String id) {
        this.id = id;
        return this;
    }

    public DeleteRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public DeleteRequest parent(String parent) {
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public DeleteRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public DeleteRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public DeleteRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readUTF();
        this.id = in.readUTF();
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
        this.refresh = in.readBoolean();
        this.version = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.type);
        out.writeUTF(this.id);
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
        out.writeBoolean(this.refresh);
        out.writeLong(this.version);
    }

    public String toString() {
        return "delete {[" + this.index + "][" + this.type + "][" + this.id + "]}";
    }
}

