/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class IndexRequest
extends ShardReplicationOperationRequest {
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    private String parent;
    private byte[] source;
    private int sourceOffset;
    private int sourceLength;
    private boolean sourceUnsafe;
    private boolean sourceFromBuilder;
    private OpType opType = OpType.INDEX;
    private boolean refresh = false;
    private long version = 0L;
    private String percolate;
    private XContentType contentType = Requests.INDEX_CONTENT_TYPE;

    public IndexRequest() {
    }

    public IndexRequest(String index) {
        this.index = index;
    }

    public IndexRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = Actions.addValidationError("type is missing", validationException);
        }
        if (this.source == null) {
            validationException = Actions.addValidationError("source is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void beforeLocalFork() {
        this.source();
    }

    public boolean sourceFromBuilder() {
        return this.sourceFromBuilder;
    }

    @Override
    public IndexRequest index(String index) {
        super.index(index);
        return this;
    }

    public IndexRequest contentType(XContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public IndexRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    @Override
    public IndexRequest operationThreaded(boolean threadedOperation) {
        super.operationThreaded(threadedOperation);
        return this;
    }

    public String type() {
        return this.type;
    }

    @Required
    public IndexRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public IndexRequest id(String id) {
        this.id = id;
        return this;
    }

    public IndexRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public IndexRequest parent(String parent) {
        this.parent = parent;
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public byte[] source() {
        if (this.sourceUnsafe || this.sourceOffset > 0) {
            this.source = Arrays.copyOfRange(this.source, this.sourceOffset, this.sourceOffset + this.sourceLength);
            this.sourceOffset = 0;
            this.sourceUnsafe = false;
        }
        return this.source;
    }

    public byte[] unsafeSource() {
        return this.source;
    }

    public int unsafeSourceOffset() {
        return this.sourceOffset;
    }

    public int unsafeSourceLength() {
        return this.sourceLength;
    }

    @Required
    public IndexRequest source(Map source) throws ElasticSearchGenerationException {
        return this.source(source, this.contentType);
    }

    @Required
    public IndexRequest source(Map source, XContentType contentType) throws ElasticSearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    @Required
    public IndexRequest source(String source) {
        UnicodeUtil.UTF8Result result = Unicode.fromStringAsUtf8(source);
        this.source = result.result;
        this.sourceOffset = 0;
        this.sourceLength = result.length;
        this.sourceUnsafe = true;
        return this;
    }

    @Required
    public IndexRequest source(XContentBuilder sourceBuilder) {
        try {
            this.source = sourceBuilder.unsafeBytes();
            this.sourceOffset = 0;
            this.sourceLength = sourceBuilder.unsafeBytesLength();
            this.sourceUnsafe = true;
            this.sourceFromBuilder = true;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + sourceBuilder + "]", e);
        }
        return this;
    }

    @Required
    public IndexRequest source(String field1, Object value1) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject().field(field1, value1).endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate", e);
        }
    }

    @Required
    public IndexRequest source(String field1, Object value1, String field2, Object value2) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject().field(field1, value1).field(field2, value2).endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate", e);
        }
    }

    @Required
    public IndexRequest source(String field1, Object value1, String field2, Object value2, String field3, Object value3) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject().field(field1, value1).field(field2, value2).field(field3, value3).endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate", e);
        }
    }

    @Required
    public IndexRequest source(String field1, Object value1, String field2, Object value2, String field3, Object value3, String field4, Object value4) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject().field(field1, value1).field(field2, value2).field(field3, value3).field(field4, value4).endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    @Required
    public IndexRequest source(byte[] source, int offset, int length) {
        return this.source(source, offset, length, false);
    }

    @Required
    public IndexRequest source(byte[] source, int offset, int length, boolean unsafe) {
        this.source = source;
        this.sourceOffset = offset;
        this.sourceLength = length;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public IndexRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public IndexRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    public IndexRequest opType(OpType opType) {
        this.opType = opType;
        return this;
    }

    public IndexRequest opType(String opType) throws ElasticSearchIllegalArgumentException {
        if ("create".equals(opType)) {
            return this.opType(OpType.CREATE);
        }
        if ("index".equals(opType)) {
            return this.opType(OpType.INDEX);
        }
        throw new ElasticSearchIllegalArgumentException("No index opType matching [" + opType + "]");
    }

    @Override
    public IndexRequest replicationType(ReplicationType replicationType) {
        super.replicationType(replicationType);
        return this;
    }

    @Override
    public IndexRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        super.consistencyLevel(consistencyLevel);
        return this;
    }

    public IndexRequest replicationType(String replicationType) {
        super.replicationType(ReplicationType.fromString(replicationType));
        return this;
    }

    public IndexRequest create(boolean create) {
        if (create) {
            return this.opType(OpType.CREATE);
        }
        return this.opType(OpType.INDEX);
    }

    public OpType opType() {
        return this.opType;
    }

    public IndexRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public IndexRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    public IndexRequest percolate(String percolate) {
        this.percolate = percolate;
        return this;
    }

    public String percolate() {
        return this.percolate;
    }

    public void processRouting(MappingMetaData mappingMd) throws ElasticSearchException {
        if (this.routing == null && mappingMd.routing().hasPath()) {
            XContentParser parser = null;
            try {
                parser = XContentFactory.xContent(this.source, this.sourceOffset, this.sourceLength).createParser(this.source, this.sourceOffset, this.sourceLength);
                this.routing = mappingMd.parseRouting(parser);
            }
            catch (Exception e) {
                throw new ElasticSearchParseException("failed to parse doc to extract routing", e);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        if (mappingMd.routing().required() && this.routing == null) {
            throw new RoutingMissingException(this.index, this.type, this.id);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readUTF();
        if (in.readBoolean()) {
            this.id = in.readUTF();
        }
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
        if (in.readBoolean()) {
            this.parent = in.readUTF();
        }
        this.sourceUnsafe = false;
        this.sourceOffset = 0;
        this.sourceLength = in.readVInt();
        this.source = new byte[this.sourceLength];
        in.readFully(this.source);
        this.opType = OpType.fromId(in.readByte());
        this.refresh = in.readBoolean();
        this.version = in.readLong();
        if (in.readBoolean()) {
            this.percolate = in.readUTF();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.type);
        if (this.id == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.id);
        }
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
        if (this.parent == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.parent);
        }
        out.writeVInt(this.sourceLength);
        out.writeBytes(this.source, this.sourceOffset, this.sourceLength);
        out.writeByte(this.opType.id());
        out.writeBoolean(this.refresh);
        out.writeLong(this.version);
        if (this.percolate == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.percolate);
        }
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = Unicode.fromBytes(this.source, this.sourceOffset, this.sourceLength);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "index {[" + this.index + "][" + this.type + "][" + this.id + "], source[" + sSource + "]}";
    }

    public static enum OpType {
        INDEX(0),
        CREATE(1);

        private byte id;

        private OpType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static OpType fromId(byte id) {
            if (id == 0) {
                return INDEX;
            }
            if (id == 1) {
                return CREATE;
            }
            throw new ElasticSearchIllegalArgumentException("No type match for [" + id + "]");
        }
    }
}

