/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUID;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.percolator.PercolatorExecutor;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndexAction
extends TransportShardReplicationOperationAction<IndexRequest, IndexResponse> {
    private final boolean autoCreateIndex;
    private final boolean allowIdGeneration;
    private final TransportCreateIndexAction createIndexAction;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final boolean waitForMappingChange;

    @Inject
    public TransportIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, TransportCreateIndexAction createIndexAction, MappingUpdatedAction mappingUpdatedAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
        this.createIndexAction = createIndexAction;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.autoCreateIndex = settings.getAsBoolean("action.auto_create_index", true);
        this.allowIdGeneration = settings.getAsBoolean("action.allow_id_generation", true);
        this.waitForMappingChange = settings.getAsBoolean("action.wait_on_mapping_change", true);
    }

    @Override
    protected void doExecute(final IndexRequest request, final ActionListener<IndexResponse> listener) {
        if (this.allowIdGeneration && request.id() == null) {
            request.id(UUID.randomBase64UUID());
            request.opType(IndexRequest.OpType.CREATE);
        }
        if (this.autoCreateIndex && !this.clusterService.state().metaData().hasConcreteIndex(request.index())) {
            this.createIndexAction.execute(new CreateIndexRequest(request.index()).cause("auto(index api)"), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportIndexAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        TransportIndexAction.this.innerExecute(request, listener);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    private void innerExecute(IndexRequest request, ActionListener<IndexResponse> listener) {
        MappingMetaData mappingMd;
        MetaData metaData = this.clusterService.state().metaData();
        request.index(metaData.concreteIndex(request.index()));
        if (metaData.hasIndex(request.index()) && (mappingMd = metaData.index(request.index()).mapping(request.type())) != null) {
            request.processRouting(mappingMd);
        }
        super.doExecute(request, listener);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected IndexRequest newRequestInstance() {
        return new IndexRequest();
    }

    @Override
    protected IndexResponse newResponseInstance() {
        return new IndexResponse();
    }

    @Override
    protected String transportAction() {
        return "indices/index/shard/index";
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected void checkBlock(IndexRequest request, ClusterState state) {
        state.blocks().indexBlockedRaiseException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, IndexRequest request) {
        return this.clusterService.operationRouting().indexShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing());
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<IndexResponse> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        long version;
        ParsedDocument doc;
        IndexRequest request = (IndexRequest)shardRequest.request;
        MappingMetaData mappingMd = clusterState.metaData().index(request.index()).mapping(request.type());
        if (mappingMd != null && mappingMd.routing().required() && request.routing() == null) {
            throw new RoutingMissingException(request.index(), request.type(), request.id());
        }
        IndexShard indexShard = this.indexShard(shardRequest);
        SourceToParse sourceToParse = SourceToParse.source(request.source()).type(request.type()).id(request.id()).routing(request.routing()).parent(request.parent());
        if (request.opType() == IndexRequest.OpType.INDEX) {
            Engine.Index index = indexShard.prepareIndex(sourceToParse).version(request.version()).origin(Engine.Operation.Origin.PRIMARY);
            index.refresh(request.refresh());
            doc = indexShard.index(index);
            version = index.version();
        } else {
            Engine.Create create = indexShard.prepareCreate(sourceToParse).version(request.version()).origin(Engine.Operation.Origin.PRIMARY);
            create.refresh(request.refresh());
            doc = indexShard.create(create);
            version = create.version();
        }
        if (doc.mappersAdded()) {
            this.updateMappingOnMaster(request);
        }
        request.version(version);
        IndexResponse response = new IndexResponse(request.index(), request.type(), request.id(), version);
        return new TransportShardReplicationOperationAction.PrimaryResponse<IndexResponse>(response, doc);
    }

    @Override
    protected void postPrimaryOperation(IndexRequest request, TransportShardReplicationOperationAction.PrimaryResponse<IndexResponse> response) {
        if (!Strings.hasLength(request.percolate())) {
            return;
        }
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        try {
            PercolatorExecutor.Response percolate = indexService.percolateService().percolate(new PercolatorExecutor.DocAndSourceQueryRequest((ParsedDocument)response.payload(), request.percolate()));
            response.response().matches(percolate.matches());
        }
        catch (Exception e) {
            this.logger.warn("failed to percolate [{}]", e, request);
        }
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        IndexShard indexShard = this.indexShard(shardRequest);
        IndexRequest request = (IndexRequest)shardRequest.request;
        SourceToParse sourceToParse = SourceToParse.source(request.source()).type(request.type()).id(request.id()).routing(request.routing()).parent(request.parent());
        if (request.opType() == IndexRequest.OpType.INDEX) {
            Engine.Index index = indexShard.prepareIndex(sourceToParse).version(request.version()).origin(Engine.Operation.Origin.REPLICA);
            index.refresh(request.refresh());
            indexShard.index(index);
        } else {
            Engine.Create create = indexShard.prepareCreate(sourceToParse).version(request.version()).origin(Engine.Operation.Origin.REPLICA);
            create.refresh(request.refresh());
            indexShard.create(create);
        }
    }

    private void updateMappingOnMaster(final IndexRequest request) {
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            MapperService mapperService = this.indicesService.indexServiceSafe(request.index()).mapperService();
            final DocumentMapper documentMapper = mapperService.documentMapper(request.type());
            if (documentMapper == null) {
                return;
            }
            documentMapper.refreshSource();
            this.mappingUpdatedAction.execute(new MappingUpdatedAction.MappingUpdatedRequest(request.index(), request.type(), documentMapper.mappingSource()), new ActionListener<MappingUpdatedAction.MappingUpdatedResponse>(){

                @Override
                public void onResponse(MappingUpdatedAction.MappingUpdatedResponse mappingUpdatedResponse) {
                    latch.countDown();
                }

                @Override
                public void onFailure(Throwable e) {
                    latch.countDown();
                    try {
                        TransportIndexAction.this.logger.warn("Failed to update master on updated mapping for index [" + request.index() + "], type [" + request.type() + "] and source [" + documentMapper.mappingSource().string() + "]", e, new Object[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            latch.countDown();
            this.logger.warn("Failed to update master on updated mapping for index [" + request.index() + "], type [" + request.type() + "]", e, new Object[0]);
        }
        if (this.waitForMappingChange) {
            try {
                latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

