/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.Scroll;

public class SearchScrollRequest
implements ActionRequest {
    private String scrollId;
    private Scroll scroll;
    private boolean listenerThreaded = false;
    private SearchOperationThreading operationThreading = SearchOperationThreading.SINGLE_THREAD;

    public SearchScrollRequest() {
    }

    public SearchScrollRequest(String scrollId) {
        this.scrollId = scrollId;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scrollId == null) {
            validationException = Actions.addValidationError("scrollId is missing", validationException);
        }
        return validationException;
    }

    public SearchOperationThreading operationThreading() {
        return this.operationThreading;
    }

    public SearchScrollRequest operationThreading(SearchOperationThreading operationThreading) {
        this.operationThreading = operationThreading;
        return this;
    }

    @Override
    public boolean listenerThreaded() {
        return this.listenerThreaded;
    }

    @Override
    public SearchScrollRequest listenerThreaded(boolean threadedListener) {
        this.listenerThreaded = threadedListener;
        return this;
    }

    public String scrollId() {
        return this.scrollId;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchScrollRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchScrollRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchScrollRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue(keepAlive, null)));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.operationThreading = SearchOperationThreading.fromId(in.readByte());
        this.scrollId = in.readUTF();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.operationThreading.id());
        out.writeUTF(this.scrollId);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
    }
}

