/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.BaseAction;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.engine.DocumentAlreadyExistsEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.VoidTransportResponseHandler;

public abstract class TransportShardReplicationOperationAction<Request extends ShardReplicationOperationRequest, Response extends ActionResponse>
extends BaseAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final IndicesService indicesService;
    protected final ShardStateAction shardStateAction;
    protected final ReplicationType defaultReplicationType;
    protected final WriteConsistencyLevel defaultWriteConsistencyLevel;
    final String transportAction;
    final String transportReplicaAction;
    final String executor;
    final boolean checkWriteConsistency;

    protected TransportShardReplicationOperationAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, threadPool);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.shardStateAction = shardStateAction;
        this.transportAction = this.transportAction();
        this.transportReplicaAction = this.transportReplicaAction();
        this.executor = this.executor();
        this.checkWriteConsistency = this.checkWriteConsistency();
        transportService.registerHandler(this.transportAction, new OperationTransportHandler());
        transportService.registerHandler(this.transportReplicaAction, new ReplicaOperationTransportHandler());
        this.defaultReplicationType = ReplicationType.fromString(settings.get("action.replication_type", "sync"));
        this.defaultWriteConsistencyLevel = WriteConsistencyLevel.fromString(settings.get("action.write_consistency", "quorum"));
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncShardOperationAction(this, request, listener).start();
    }

    protected abstract Request newRequestInstance();

    protected abstract Response newResponseInstance();

    protected abstract String transportAction();

    protected abstract String executor();

    protected abstract PrimaryResponse<Response> shardOperationOnPrimary(ClusterState var1, ShardOperationRequest var2);

    protected abstract void shardOperationOnReplica(ShardOperationRequest var1);

    protected void postPrimaryOperation(Request request, PrimaryResponse<Response> response) {
    }

    protected abstract ShardIterator shards(ClusterState var1, Request var2) throws ElasticSearchException;

    protected abstract boolean checkWriteConsistency();

    protected void checkBlock(Request request, ClusterState state) {
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected boolean ignoreReplicas() {
        return false;
    }

    private String transportReplicaAction() {
        return this.transportAction() + "/replica";
    }

    protected IndexShard indexShard(ShardOperationRequest shardRequest) {
        return this.indicesService.indexServiceSafe(((ShardReplicationOperationRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
    }

    public static class PrimaryResponse<T> {
        private final T response;
        private final Object payload;

        public PrimaryResponse(T response, Object payload) {
            this.response = response;
            this.payload = payload;
        }

        public T response() {
            return this.response;
        }

        public Object payload() {
            return this.payload;
        }
    }

    protected static class AsyncShardOperationAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private DiscoveryNodes nodes;
        private ShardIterator shardIt;
        private final AtomicBoolean primaryOperationStarted = new AtomicBoolean();
        private final ReplicationType replicationType;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        AsyncShardOperationAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = var1_1.clusterService.state();
            ((ShardReplicationOperationRequest)request).index(clusterState.metaData().concreteIndex(((ShardReplicationOperationRequest)request).index()));
            var1_1.checkBlock(request, clusterState);
            this.replicationType = ((ShardReplicationOperationRequest)request).replicationType() != ReplicationType.DEFAULT ? ((ShardReplicationOperationRequest)request).replicationType() : var1_1.defaultReplicationType;
        }

        public void start() {
            this.start(false);
        }

        public boolean start(final boolean fromClusterEvent) throws ElasticSearchException {
            final ClusterState clusterState = this.this$0.clusterService.state();
            this.nodes = clusterState.nodes();
            if (!clusterState.routingTable().hasIndex(((ShardReplicationOperationRequest)this.request).index())) {
                this.retry(fromClusterEvent, null);
                return false;
            }
            try {
                this.shardIt = this.this$0.shards(clusterState, this.request);
            }
            catch (Exception e) {
                this.listener.onFailure(e);
                return true;
            }
            if (this.shardIt.size() == 0) {
                this.retry(fromClusterEvent, this.shardIt.shardId());
                return false;
            }
            boolean foundPrimary = false;
            for (final ShardRouting shard : this.shardIt) {
                if (!shard.primary()) continue;
                if (!shard.active() || !this.nodes.nodeExists(shard.currentNodeId())) {
                    this.retry(fromClusterEvent, shard.shardId());
                    return false;
                }
                if (this.this$0.checkWriteConsistency) {
                    WriteConsistencyLevel consistencyLevel = this.this$0.defaultWriteConsistencyLevel;
                    if (((ShardReplicationOperationRequest)this.request).consistencyLevel() != WriteConsistencyLevel.DEFAULT) {
                        consistencyLevel = ((ShardReplicationOperationRequest)this.request).consistencyLevel();
                    }
                    int requiredNumber = 1;
                    if (consistencyLevel == WriteConsistencyLevel.QUORUM && this.shardIt.size() > 2) {
                        requiredNumber = this.shardIt.size() / 2 + 1;
                    } else if (consistencyLevel == WriteConsistencyLevel.ALL) {
                        requiredNumber = this.shardIt.size();
                    }
                    if (this.shardIt.sizeActive() < requiredNumber) {
                        this.retry(fromClusterEvent, shard.shardId());
                        return false;
                    }
                }
                if (!this.primaryOperationStarted.compareAndSet(false, true)) {
                    return true;
                }
                foundPrimary = true;
                if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                    if (((ShardReplicationOperationRequest)this.request).operationThreaded()) {
                        ((ShardReplicationOperationRequest)this.request).beforeLocalFork();
                        this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                            @Override
                            public void run() {
                                AsyncShardOperationAction.this.performOnPrimary(shard.id(), fromClusterEvent, shard, clusterState);
                            }
                        });
                        break;
                    }
                    this.performOnPrimary(shard.id(), fromClusterEvent, shard, clusterState);
                    break;
                }
                DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                this.this$0.transportService.sendRequest(node, this.this$0.transportAction, (Streamable)this.request, this.this$0.transportOptions(), new BaseTransportResponseHandler<Response>(){

                    @Override
                    public Response newInstance() {
                        return AsyncShardOperationAction.this.this$0.newResponseInstance();
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncShardOperationAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        if (exp.unwrapCause() instanceof ConnectTransportException || exp.unwrapCause() instanceof NodeClosedException || exp.unwrapCause() instanceof IllegalIndexShardStateException) {
                            AsyncShardOperationAction.this.primaryOperationStarted.set(false);
                            AsyncShardOperationAction.this.retry(false, shard.shardId());
                        } else {
                            AsyncShardOperationAction.this.listener.onFailure(exp);
                        }
                    }
                });
                break;
            }
            if (!foundPrimary) {
                UnavailableShardsException failure = new UnavailableShardsException(this.shardIt.shardId(), this.request.toString());
                this.listener.onFailure(failure);
            }
            return true;
        }

        private void retry(boolean fromClusterEvent, final ShardId shardId) {
            if (!fromClusterEvent) {
                ((ShardReplicationOperationRequest)this.request).beforeLocalFork();
                ((ShardReplicationOperationRequest)this.request).operationThreaded(true);
                this.this$0.clusterService.add(((ShardReplicationOperationRequest)this.request).timeout(), new TimeoutClusterStateListener(){

                    @Override
                    public void postAdded() {
                        if (AsyncShardOperationAction.this.start(true)) {
                            AsyncShardOperationAction.this.this$0.clusterService.remove(this);
                        }
                    }

                    @Override
                    public void onClose() {
                        AsyncShardOperationAction.this.this$0.clusterService.remove(this);
                        AsyncShardOperationAction.this.listener.onFailure(new NodeClosedException(AsyncShardOperationAction.this.nodes.localNode()));
                    }

                    @Override
                    public void clusterChanged(ClusterChangedEvent event) {
                        if (AsyncShardOperationAction.this.start(true)) {
                            AsyncShardOperationAction.this.this$0.clusterService.remove(this);
                        }
                    }

                    @Override
                    public void onTimeout(TimeValue timeValue) {
                        if (AsyncShardOperationAction.this.start(true)) {
                            AsyncShardOperationAction.this.this$0.clusterService.remove(this);
                            return;
                        }
                        AsyncShardOperationAction.this.this$0.clusterService.remove(this);
                        UnavailableShardsException failure = new UnavailableShardsException(shardId, "[" + AsyncShardOperationAction.this.shardIt.size() + "] shardIt, [" + AsyncShardOperationAction.this.shardIt.sizeActive() + "] active : Timeout waiting for [" + timeValue + "], request: " + AsyncShardOperationAction.this.request.toString());
                        AsyncShardOperationAction.this.listener.onFailure(failure);
                    }
                });
            }
        }

        private void performOnPrimary(int primaryShardId, boolean fromDiscoveryListener, ShardRouting shard, ClusterState clusterState) {
            try {
                PrimaryResponse response = this.this$0.shardOperationOnPrimary(clusterState, new ShardOperationRequest(this.this$0, primaryShardId, this.request));
                this.performReplicas(response);
            }
            catch (Exception e) {
                if (e instanceof IndexShardMissingException || e instanceof IllegalIndexShardStateException || e instanceof IndexMissingException) {
                    this.retry(fromDiscoveryListener, shard.shardId());
                    return;
                }
                if (this.this$0.logger.isDebugEnabled()) {
                    this.this$0.logger.debug(shard.shortSummary() + ": Failed to execute [" + this.request + "]", e, new Object[0]);
                }
                this.listener.onFailure(e);
            }
        }

        private void performReplicas(PrimaryResponse<Response> response) {
            if (this.this$0.ignoreReplicas() || this.shardIt.size() == 1) {
                this.this$0.postPrimaryOperation(this.request, response);
                this.listener.onResponse(response.response());
                return;
            }
            int replicaCounter = 0;
            for (ShardRouting shard : this.shardIt.reset()) {
                if (shard.unassigned()) continue;
                if (shard.primary()) {
                    if (!shard.relocating()) continue;
                    ++replicaCounter;
                    continue;
                }
                ++replicaCounter;
                if (!shard.relocating()) continue;
                ++replicaCounter;
            }
            if (replicaCounter == 0) {
                this.this$0.postPrimaryOperation(this.request, response);
                this.listener.onResponse(response.response());
                return;
            }
            if (this.replicationType == ReplicationType.ASYNC) {
                this.this$0.postPrimaryOperation(this.request, response);
                this.listener.onResponse(response.response());
                replicaCounter = -100;
            }
            AtomicInteger counter = new AtomicInteger(++replicaCounter);
            for (ShardRouting shard : this.shardIt.reset()) {
                if (shard.unassigned()) continue;
                boolean doOnlyOnRelocating = false;
                if (shard.primary()) {
                    if (!shard.relocating()) continue;
                    doOnlyOnRelocating = true;
                }
                if (!doOnlyOnRelocating) {
                    this.performOnReplica(response, counter, shard, shard.currentNodeId());
                }
                if (!shard.relocating()) continue;
                this.performOnReplica(response, counter, shard, shard.relocatingNodeId());
            }
            this.this$0.postPrimaryOperation(this.request, response);
            if (counter.decrementAndGet() == 0) {
                this.listener.onResponse(response.response());
            }
        }

        private void performOnReplica(final PrimaryResponse<Response> response, final AtomicInteger counter, final ShardRouting shard, String nodeId) {
            if (!this.nodes.nodeExists(nodeId)) {
                if (counter.decrementAndGet() == 0) {
                    this.listener.onResponse(response.response());
                }
                return;
            }
            final ShardOperationRequest shardRequest = new ShardOperationRequest(this.this$0, this.shardIt.shardId().id(), this.request);
            if (!nodeId.equals(this.nodes.localNodeId())) {
                DiscoveryNode node = this.nodes.get(nodeId);
                this.this$0.transportService.sendRequest(node, this.this$0.transportReplicaAction, shardRequest, this.this$0.transportOptions(), new VoidTransportResponseHandler("same"){

                    @Override
                    public void handleResponse(VoidStreamable vResponse) {
                        this.finishIfPossible();
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        if (!AsyncShardOperationAction.this.ignoreReplicaException(exp.unwrapCause())) {
                            AsyncShardOperationAction.this.this$0.logger.warn("Failed to perform " + AsyncShardOperationAction.this.this$0.transportAction + " on replica " + AsyncShardOperationAction.this.shardIt.shardId(), exp, new Object[0]);
                            AsyncShardOperationAction.this.this$0.shardStateAction.shardFailed(shard, "Failed to perform [" + AsyncShardOperationAction.this.this$0.transportAction + "] on replica, message [" + ExceptionsHelper.detailedMessage(exp) + "]");
                        }
                        this.finishIfPossible();
                    }

                    private void finishIfPossible() {
                        if (counter.decrementAndGet() == 0) {
                            AsyncShardOperationAction.this.listener.onResponse(response.response());
                        }
                    }
                });
            } else if (((ShardReplicationOperationRequest)this.request).operationThreaded()) {
                ((ShardReplicationOperationRequest)this.request).beforeLocalFork();
                this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                AsyncShardOperationAction.this.this$0.shardOperationOnReplica(shardRequest);
                            }
                            catch (Exception e) {
                                if (AsyncShardOperationAction.this.ignoreReplicaException(e)) break block3;
                                AsyncShardOperationAction.this.this$0.logger.warn("Failed to perform " + AsyncShardOperationAction.this.this$0.transportAction + " on replica " + AsyncShardOperationAction.this.shardIt.shardId(), e, new Object[0]);
                                AsyncShardOperationAction.this.this$0.shardStateAction.shardFailed(shard, "Failed to perform [" + AsyncShardOperationAction.this.this$0.transportAction + "] on replica, message [" + ExceptionsHelper.detailedMessage(e) + "]");
                            }
                        }
                        if (counter.decrementAndGet() == 0) {
                            AsyncShardOperationAction.this.listener.onResponse(response.response());
                        }
                    }
                });
            } else {
                block9: {
                    try {
                        this.this$0.shardOperationOnReplica(shardRequest);
                    }
                    catch (Exception e) {
                        if (this.ignoreReplicaException(e)) break block9;
                        this.this$0.logger.warn("Failed to perform " + this.this$0.transportAction + " on replica" + this.shardIt.shardId(), e, new Object[0]);
                        this.this$0.shardStateAction.shardFailed(shard, "Failed to perform [" + this.this$0.transportAction + "] on replica, message [" + ExceptionsHelper.detailedMessage(e) + "]");
                    }
                }
                if (counter.decrementAndGet() == 0) {
                    this.listener.onResponse(response.response());
                }
            }
        }

        private boolean ignoreReplicaException(Throwable e) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            if (cause instanceof IllegalIndexShardStateException) {
                return true;
            }
            if (cause instanceof IndexMissingException) {
                return true;
            }
            if (cause instanceof IndexShardMissingException) {
                return true;
            }
            if (cause instanceof ConnectTransportException) {
                return true;
            }
            if (cause instanceof VersionConflictEngineException) {
                return true;
            }
            return cause instanceof DocumentAlreadyExistsEngineException;
        }
    }

    protected class ShardOperationRequest
    implements Streamable {
        public int shardId;
        public Request request;

        public ShardOperationRequest() {
        }

        public ShardOperationRequest(int shardId, Request request) {
            this.shardId = shardId;
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.shardId = in.readVInt();
            this.request = TransportShardReplicationOperationAction.this.newRequestInstance();
            ((ShardReplicationOperationRequest)this.request).readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.shardId);
            ((ShardReplicationOperationRequest)this.request).writeTo(out);
        }
    }

    class ReplicaOperationTransportHandler
    extends BaseTransportRequestHandler<ShardOperationRequest> {
        ReplicaOperationTransportHandler() {
        }

        @Override
        public ShardOperationRequest newInstance() {
            return new ShardOperationRequest();
        }

        @Override
        public String executor() {
            return TransportShardReplicationOperationAction.this.executor;
        }

        @Override
        public void messageReceived(ShardOperationRequest request, TransportChannel channel) throws Exception {
            TransportShardReplicationOperationAction.this.shardOperationOnReplica(request);
            channel.sendResponse(VoidStreamable.INSTANCE);
        }
    }

    class OperationTransportHandler
    extends BaseTransportRequestHandler<Request> {
        OperationTransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportShardReplicationOperationAction.this.newRequestInstance();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ShardReplicationOperationRequest)request).listenerThreaded(false);
            ((ShardReplicationOperationRequest)request).operationThreaded(true);
            TransportShardReplicationOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((Streamable)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportShardReplicationOperationAction.this.logger.warn("Failed to send response for " + TransportShardReplicationOperationAction.this.transportAction, e1, new Object[0]);
                    }
                }
            });
        }
    }
}

