/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.index.shard.ShardId;

public class IndexShardRoutingTable
implements Iterable<ShardRouting> {
    final ShardId shardId;
    final ImmutableList<ShardRouting> shards;
    final AtomicInteger counter;
    final boolean allocatedPostApi;

    IndexShardRoutingTable(ShardId shardId, ImmutableList<ShardRouting> shards, boolean allocatedPostApi) {
        this.shardId = shardId;
        this.shards = shards;
        this.allocatedPostApi = allocatedPostApi;
        this.counter = new AtomicInteger(ThreadLocalRandom.current().nextInt(shards.size()));
    }

    public boolean allocatedPostApi() {
        return this.allocatedPostApi;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId();
    }

    @Override
    public UnmodifiableIterator<ShardRouting> iterator() {
        return this.shards.iterator();
    }

    public int size() {
        return this.shards.size();
    }

    public int getSize() {
        return this.size();
    }

    public ImmutableList<ShardRouting> shards() {
        return this.shards;
    }

    public ImmutableList<ShardRouting> getShards() {
        return this.shards();
    }

    public int countWithState(ShardRoutingState state) {
        int count = 0;
        for (ShardRouting shard : this) {
            if (state != shard.state()) continue;
            ++count;
        }
        return count;
    }

    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId, this.shards);
    }

    public ShardIterator shardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.shards, this.counter.getAndIncrement());
    }

    public ShardRouting primaryShard() {
        for (ShardRouting shardRouting : this) {
            if (!shardRouting.primary()) continue;
            return shardRouting;
        }
        return null;
    }

    public List<ShardRouting> replicaShards() {
        ArrayList<ShardRouting> replicaShards = Lists.newArrayListWithCapacity(2);
        for (ShardRouting shardRouting : this) {
            if (shardRouting.primary()) continue;
            replicaShards.add(shardRouting);
        }
        return replicaShards;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = Lists.newArrayList();
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public static class Builder {
        private ShardId shardId;
        private final List<ShardRouting> shards;
        private boolean allocatedPostApi;

        public Builder(IndexShardRoutingTable indexShard) {
            this.shardId = indexShard.shardId;
            this.shards = Lists.newArrayList(indexShard.shards);
            this.allocatedPostApi = indexShard.allocatedPostApi();
        }

        public Builder(ShardId shardId, boolean allocatedPostApi) {
            this.shardId = shardId;
            this.shards = Lists.newArrayList();
            this.allocatedPostApi = allocatedPostApi;
        }

        public Builder addShard(ImmutableShardRouting shardEntry) {
            for (ShardRouting shard : this.shards) {
                if (!shard.assignedToNode() || !shardEntry.assignedToNode() || !shard.currentNodeId().equals(shardEntry.currentNodeId())) continue;
                return this;
            }
            this.shards.add(shardEntry);
            return this;
        }

        public Builder removeShard(ShardRouting shardEntry) {
            this.shards.remove(shardEntry);
            return this;
        }

        public IndexShardRoutingTable build() {
            if (!this.allocatedPostApi) {
                for (ShardRouting shardRouting : this.shards) {
                    if (!shardRouting.primary() || !shardRouting.active()) continue;
                    this.allocatedPostApi = true;
                }
            }
            return new IndexShardRoutingTable(this.shardId, ImmutableList.copyOf(this.shards), this.allocatedPostApi);
        }

        public static IndexShardRoutingTable readFrom(StreamInput in) throws IOException {
            String index = in.readUTF();
            return Builder.readFromThin(in, index);
        }

        public static IndexShardRoutingTable readFromThin(StreamInput in, String index) throws IOException {
            int iShardId = in.readVInt();
            boolean allocatedPostApi = in.readBoolean();
            Builder builder = new Builder(new ShardId(index, iShardId), allocatedPostApi);
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                ImmutableShardRouting shard = ImmutableShardRouting.readShardRoutingEntry(in, index, iShardId);
                builder.addShard(shard);
            }
            return builder.build();
        }

        public static void writeTo(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeUTF(indexShard.shardId().index().name());
            Builder.writeToThin(indexShard, out);
        }

        public static void writeToThin(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeVInt(indexShard.shardId.id());
            out.writeBoolean(indexShard.allocatedPostApi());
            out.writeVInt(indexShard.shards.size());
            for (ShardRouting entry : indexShard) {
                entry.writeToThin(out);
            }
        }
    }
}

