/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.NodeAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ThrottlingNodeAllocation
extends NodeAllocation {
    private final int concurrentRecoveries;

    @Inject
    public ThrottlingNodeAllocation(Settings settings) {
        super(settings);
        this.concurrentRecoveries = this.componentSettings.getAsInt("concurrent_recoveries", 2);
    }

    @Override
    public NodeAllocation.Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            boolean primaryUnassigned = false;
            for (MutableShardRouting shard : allocation.routingNodes().unassigned()) {
                if (!shard.shardId().equals(shardRouting.shardId())) continue;
                primaryUnassigned = true;
            }
            if (primaryUnassigned) {
                int primariesInRecovery = 0;
                for (MutableShardRouting shard : node) {
                    if (shard.state() != ShardRoutingState.INITIALIZING || !shard.primary()) continue;
                    ++primariesInRecovery;
                }
                if (primariesInRecovery >= this.concurrentRecoveries) {
                    return NodeAllocation.Decision.THROTTLE;
                }
                return NodeAllocation.Decision.YES;
            }
        }
        int currentRecoveries = 0;
        for (MutableShardRouting shard : node) {
            if (shard.state() != ShardRoutingState.INITIALIZING && shard.state() != ShardRoutingState.RELOCATING) continue;
            ++currentRecoveries;
        }
        if (currentRecoveries >= this.concurrentRecoveries) {
            return NodeAllocation.Decision.THROTTLE;
        }
        return NodeAllocation.Decision.YES;
    }
}

