/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.OutputStream;

public class LZFChunk {
    public static final int MAX_LITERAL = 32;
    public static final int MAX_CHUNK_LEN = 65535;
    public static final byte BYTE_Z = 90;
    public static final byte BYTE_V = 86;
    public static final int BLOCK_TYPE_NON_COMPRESSED = 0;
    public static final int BLOCK_TYPE_COMPRESSED = 1;
    final byte[] _data;
    LZFChunk _next;

    private LZFChunk(byte[] data) {
        this._data = data;
    }

    public static int createCompressed(OutputStream os, int origLen, byte[] encData, int encPtr, int encLen) throws IOException {
        os.write(90);
        os.write(86);
        os.write(1);
        os.write(encLen >> 8);
        os.write(encLen);
        os.write(origLen >> 8);
        os.write(origLen);
        os.write(encData, encPtr, encLen);
        return encLen + 7;
    }

    public static LZFChunk createCompressed(int origLen, byte[] encData, int encPtr, int encLen) {
        byte[] result = new byte[encLen + 7];
        result[0] = 90;
        result[1] = 86;
        result[2] = 1;
        result[3] = (byte)(encLen >> 8);
        result[4] = (byte)encLen;
        result[5] = (byte)(origLen >> 8);
        result[6] = (byte)origLen;
        System.arraycopy(encData, encPtr, result, 7, encLen);
        return new LZFChunk(result);
    }

    public static int createNonCompressed(OutputStream os, byte[] plainData, int ptr, int len) throws IOException {
        os.write(90);
        os.write(86);
        os.write(0);
        os.write(len >> 8);
        os.write(len);
        os.write(plainData, ptr, len);
        return len + 5;
    }

    public static LZFChunk createNonCompressed(byte[] plainData, int ptr, int len) {
        byte[] result = new byte[len + 5];
        result[0] = 90;
        result[1] = 86;
        result[2] = 0;
        result[3] = (byte)(len >> 8);
        result[4] = (byte)len;
        System.arraycopy(plainData, ptr, result, 5, len);
        return new LZFChunk(result);
    }

    public void setNext(LZFChunk next) {
        this._next = next;
    }

    public LZFChunk next() {
        return this._next;
    }

    public int length() {
        return this._data.length;
    }

    public byte[] getData() {
        return this._data;
    }

    public int copyTo(byte[] dst, int ptr) {
        int len = this._data.length;
        System.arraycopy(this._data, 0, dst, ptr, len);
        return ptr + len;
    }
}

