/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.compress.lzf.LZFDecoder;

public class LZFInputStream
extends InputStream {
    public static final int EOF_FLAG = -1;
    private final InputStream inputStream;
    private final byte[] compressedBytes = new byte[65535];
    private final byte[] uncompressedBytes = new byte[65535];
    private int bufferPosition = 0;
    private int bufferLength = 0;

    public LZFInputStream(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        int returnValue = -1;
        this.readyBuffer();
        if (this.bufferPosition < this.bufferLength) {
            returnValue = this.uncompressedBytes[this.bufferPosition++] & 0xFF;
        }
        return returnValue;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int outputPos = offset;
        this.readyBuffer();
        if (this.bufferLength == -1) {
            return -1;
        }
        while (outputPos < length && this.bufferPosition < this.bufferLength) {
            int chunkLength = Math.min(this.bufferLength - this.bufferPosition, length - outputPos);
            System.arraycopy(this.uncompressedBytes, this.bufferPosition, buffer, outputPos, chunkLength);
            outputPos += chunkLength;
            this.bufferPosition += chunkLength;
            this.readyBuffer();
        }
        return outputPos - offset;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private void readyBuffer() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.bufferLength = LZFDecoder.decompressChunk(this.inputStream, this.compressedBytes, this.uncompressedBytes);
            this.bufferPosition = 0;
        }
    }
}

