/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.elasticsearch.common.inject.internal.ConstructionContext;
import org.elasticsearch.common.inject.internal.ConstructionProxy;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.internal.MembersInjectorImpl;
import org.elasticsearch.common.inject.internal.SingleParameterInjector;
import org.elasticsearch.common.inject.internal.util.$ImmutableSet;
import org.elasticsearch.common.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConstructorInjector<T> {
    private final $ImmutableSet<InjectionPoint> injectableMembers;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final ConstructionProxy<T> constructionProxy;
    private final MembersInjectorImpl<T> membersInjector;

    ConstructorInjector(Set<InjectionPoint> injectableMembers, ConstructionProxy<T> constructionProxy, SingleParameterInjector<?>[] parameterInjectors, MembersInjectorImpl<T> membersInjector) {
        this.injectableMembers = $ImmutableSet.copyOf(injectableMembers);
        this.constructionProxy = constructionProxy;
        this.parameterInjectors = parameterInjectors;
        this.membersInjector = membersInjector;
    }

    public $ImmutableSet<InjectionPoint> getInjectableMembers() {
        return this.injectableMembers;
    }

    ConstructionProxy<T> getConstructionProxy() {
        return this.constructionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(Errors errors, InternalContext context, Class<?> expectedType, boolean allowProxy) throws ErrorsException {
        ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            if (!allowProxy) {
                throw errors.circularProxiesDisabled(expectedType).toException();
            }
            return constructionContext.createProxy(errors, expectedType);
        }
        Object t = constructionContext.getCurrentReference();
        if (t != null) {
            return t;
        }
        try {
            Object parameters;
            constructionContext.startConstruction();
            try {
                parameters = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
                t = this.constructionProxy.newInstance(parameters);
                constructionContext.setProxyDelegates(t);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t);
            this.membersInjector.injectMembers(t, errors, context, false);
            this.membersInjector.notifyListeners(t, errors);
            parameters = t;
            return parameters;
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw errors.withSource(this.constructionProxy.getInjectionPoint()).errorInjectingConstructor(cause).toException();
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }
}

