/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import org.elasticsearch.common.inject.internal.ConstructorInjector;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.FailableCache;
import org.elasticsearch.common.inject.internal.InjectorImpl;
import org.elasticsearch.common.inject.internal.MembersInjectorImpl;
import org.elasticsearch.common.inject.internal.MethodAspect;
import org.elasticsearch.common.inject.internal.ProxyFactory;
import org.elasticsearch.common.inject.internal.SingleParameterInjector;
import org.elasticsearch.common.inject.internal.util.$ImmutableList;
import org.elasticsearch.common.inject.internal.util.$Iterables;
import org.elasticsearch.common.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        $ImmutableList<MethodAspect> injectorAspects = this.injector.state.getMethodAspects();
        $ImmutableList<MethodAspect> methodAspects = membersInjector.getAddedAspects().isEmpty() ? injectorAspects : $ImmutableList.copyOf($Iterables.concat(injectorAspects, membersInjector.getAddedAspects()));
        ProxyFactory factory = new ProxyFactory(injectionPoint, methodAspects);
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

