/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.util.List;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.InjectorImpl;
import org.elasticsearch.common.inject.internal.LookupProcessor;
import org.elasticsearch.common.inject.internal.Lookups;
import org.elasticsearch.common.inject.internal.util.$Lists;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.MembersInjectorLookup;
import org.elasticsearch.common.inject.spi.ProviderLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = $Lists.newArrayList();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

