/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Provides;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Annotations;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ProviderMethod;
import org.elasticsearch.common.inject.internal.UniqueAnnotations;
import org.elasticsearch.common.inject.internal.util.$ImmutableSet;
import org.elasticsearch.common.inject.internal.util.$Lists;
import org.elasticsearch.common.inject.internal.util.$Preconditions;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.inject.util.Modules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderMethodsModule
implements Module {
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;

    private ProviderMethodsModule(Object delegate) {
        this.delegate = $Preconditions.checkNotNull(delegate, "delegate");
        this.typeLiteral = TypeLiteral.get(this.delegate.getClass());
    }

    public static Module forModule(Module module) {
        return ProviderMethodsModule.forObject(module);
    }

    public static Module forObject(Object object) {
        if (object instanceof ProviderMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new ProviderMethodsModule(object);
    }

    @Override
    public synchronized void configure(Binder binder) {
        for (ProviderMethod<?> providerMethod : this.getProviderMethods(binder)) {
            providerMethod.configure(binder);
        }
    }

    public List<ProviderMethod<?>> getProviderMethods(Binder binder) {
        ArrayList<ProviderMethod<?>> result = $Lists.newArrayList();
        for (Class<?> c = this.delegate.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Provides.class)) continue;
                result.add(this.createProviderMethod(binder, method));
            }
        }
        return result;
    }

    <T> ProviderMethod<T> createProviderMethod(Binder binder, Method method) {
        Key<Object> key;
        binder = binder.withSource(method);
        Errors errors = new Errors(method);
        ArrayList<Dependency<?>> dependencies = $Lists.newArrayList();
        ArrayList<Provider<?>> parameterProviders = $Lists.newArrayList();
        List<TypeLiteral<?>> parameterTypes = this.typeLiteral.getParameterTypes(method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            key = this.getKey(errors, parameterTypes.get(i), method, parameterAnnotations[i]);
            if (key.equals(Key.get(Logger.class))) {
                Key<Logger> loggerKey = Key.get(Logger.class, UniqueAnnotations.create());
                binder.bind(loggerKey).toProvider(new LogProvider(method));
                key = loggerKey;
            }
            dependencies.add(Dependency.get(key));
            parameterProviders.add(binder.getProvider(key));
        }
        TypeLiteral<?> returnType = this.typeLiteral.getReturnType(method);
        key = this.getKey(errors, returnType, method, method.getAnnotations());
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, method.getAnnotations());
        for (Message message : errors.getMessages()) {
            binder.addError(message);
        }
        return new ProviderMethod(key, method, this.delegate, $ImmutableSet.copyOf(dependencies), parameterProviders, scopeAnnotation);
    }

    <T> Key<T> getKey(Errors errors, TypeLiteral<T> type, Member member, Annotation[] annotations) {
        Annotation bindingAnnotation = Annotations.findBindingAnnotation(errors, member, annotations);
        return bindingAnnotation == null ? Key.get(type) : Key.get(type, bindingAnnotation);
    }

    public boolean equals(Object o) {
        return o instanceof ProviderMethodsModule && ((ProviderMethodsModule)o).delegate == this.delegate;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LogProvider
    implements Provider<Logger> {
        private final String name;

        public LogProvider(Method method) {
            this.name = method.getDeclaringClass().getName() + "." + method.getName();
        }

        @Override
        public Logger get() {
            return Logger.getLogger(this.name);
        }
    }
}

