/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.LZFStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.thread.ThreadLocals;

public class CachedStreamInput {
    private static final ThreadLocal<ThreadLocals.CleanableValue<Entry>> cache = new ThreadLocal<ThreadLocals.CleanableValue<Entry>>(){

        @Override
        protected ThreadLocals.CleanableValue<Entry> initialValue() {
            HandlesStreamInput handles = new HandlesStreamInput();
            LZFStreamInput lzf = new LZFStreamInput();
            return new ThreadLocals.CleanableValue<Entry>(new Entry(handles, lzf));
        }
    };

    public static LZFStreamInput cachedLzf(StreamInput in) throws IOException {
        LZFStreamInput lzf = CachedStreamInput.cache.get().get().lzf;
        lzf.reset(in);
        return lzf;
    }

    public static HandlesStreamInput cachedHandles(StreamInput in) {
        HandlesStreamInput handles = CachedStreamInput.cache.get().get().handles;
        handles.reset(in);
        return handles;
    }

    public static HandlesStreamInput cachedHandlesLzf(StreamInput in) throws IOException {
        Entry entry = cache.get().get();
        entry.lzf.reset(in);
        entry.handles.reset(entry.lzf);
        return entry.handles;
    }

    static class Entry {
        final HandlesStreamInput handles;
        final LZFStreamInput lzf;

        Entry(HandlesStreamInput handles, LZFStreamInput lzf) {
            this.handles = handles;
            this.lzf = lzf;
        }
    }
}

