/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.smile;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.jackson.JsonLocation;
import org.elasticsearch.common.jackson.JsonParseException;
import org.elasticsearch.common.jackson.JsonParser;
import org.elasticsearch.common.jackson.ObjectCodec;
import org.elasticsearch.common.jackson.io.IOContext;
import org.elasticsearch.common.jackson.smile.SmileParser;
import org.elasticsearch.common.jackson.sym.BytesToNameCanonicalizer;

public class SmileParserBootstrapper {
    final IOContext _context;
    final InputStream _in;
    final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public SmileParserBootstrapper(IOContext ctxt, InputStream in) {
        this._context = ctxt;
        this._in = in;
        this._inputBuffer = ctxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public SmileParserBootstrapper(IOContext ctxt, byte[] inputBuffer, int inputStart, int inputLen) {
        this._context = ctxt;
        this._in = null;
        this._inputBuffer = inputBuffer;
        this._inputPtr = inputStart;
        this._inputEnd = inputStart + inputLen;
        this._inputProcessed = -inputStart;
        this._bufferRecyclable = false;
    }

    public SmileParser constructParser(int generalParserFeatures, int smileFeatures, ObjectCodec codec, BytesToNameCanonicalizer rootByteSymbols) throws IOException, JsonParseException {
        boolean intern = JsonParser.Feature.INTERN_FIELD_NAMES.enabledIn(generalParserFeatures);
        BytesToNameCanonicalizer can = rootByteSymbols.makeChild(true, intern);
        this.ensureLoaded(1);
        SmileParser p = new SmileParser(this._context, generalParserFeatures, smileFeatures, codec, can, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        boolean hadSig = false;
        if (this._inputPtr < this._inputEnd && this._inputBuffer[this._inputPtr] == 58) {
            hadSig = p.handleSignature(true, true);
        }
        if (!hadSig && (smileFeatures & SmileParser.Feature.REQUIRE_HEADER.getMask()) != 0) {
            byte firstByte = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr] : (byte)0;
            String msg = firstByte == 123 || firstByte == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(firstByte & 0xFF) + ") -- rather, it starts with '" + (char)firstByte + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(firstByte & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
            throw new JsonParseException(msg, JsonLocation.NA);
        }
        return p;
    }

    protected boolean ensureLoaded(int minimum) throws IOException {
        int count;
        if (this._in == null) {
            return false;
        }
        for (int gotten = this._inputEnd - this._inputPtr; gotten < minimum; gotten += count) {
            count = this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (count < 1) {
                return false;
            }
            this._inputEnd += count;
        }
        return true;
    }
}

