/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda.time.convert;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.elasticsearch.common.joda.time.Chronology;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.chrono.BuddhistChronology;
import org.elasticsearch.common.joda.time.chrono.GJChronology;
import org.elasticsearch.common.joda.time.chrono.GregorianChronology;
import org.elasticsearch.common.joda.time.chrono.ISOChronology;
import org.elasticsearch.common.joda.time.chrono.JulianChronology;
import org.elasticsearch.common.joda.time.convert.AbstractConverter;
import org.elasticsearch.common.joda.time.convert.InstantConverter;
import org.elasticsearch.common.joda.time.convert.PartialConverter;

final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();
    static /* synthetic */ Class class$java$util$Calendar;

    protected CalendarConverter() {
    }

    public Chronology getChronology(Object object, Chronology chronology) {
        if (chronology != null) {
            return chronology;
        }
        Calendar calendar = (Calendar)object;
        DateTimeZone dateTimeZone = null;
        try {
            dateTimeZone = DateTimeZone.forTimeZone(calendar.getTimeZone());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)calendar, dateTimeZone);
    }

    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(dateTimeZone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            long l = gregorianCalendar.getGregorianChange().getTime();
            if (l == Long.MIN_VALUE) {
                return GregorianChronology.getInstance(dateTimeZone);
            }
            if (l == Long.MAX_VALUE) {
                return JulianChronology.getInstance(dateTimeZone);
            }
            return GJChronology.getInstance(dateTimeZone, l, 4);
        }
        return ISOChronology.getInstance(dateTimeZone);
    }

    public long getInstantMillis(Object object, Chronology chronology) {
        Calendar calendar = (Calendar)object;
        return calendar.getTime().getTime();
    }

    public Class getSupportedType() {
        return class$java$util$Calendar == null ? (class$java$util$Calendar = CalendarConverter.class$("java.util.Calendar")) : class$java$util$Calendar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

