/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.list.array.TIntArrayList;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;

public class Lucene {
    public static final Version VERSION;
    public static final Version ANALYZER_VERSION;
    public static final Version QUERYPARSER_VERSION;
    public static final NamedAnalyzer STANDARD_ANALYZER;
    public static final NamedAnalyzer KEYWORD_ANALYZER;
    public static final int NO_DOC = -1;

    public static long count(IndexSearcher searcher, Query query, float minScore) throws IOException {
        CountCollector countCollector = new CountCollector(minScore);
        searcher.search(query, (Collector)countCollector);
        return countCollector.count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int docId(IndexReader reader, Term term) throws IOException {
        TermDocs termDocs = reader.termDocs(term);
        try {
            if (termDocs.next()) {
                int n = termDocs.doc();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            termDocs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntArrayList docIds(IndexReader reader, Term term, int expectedSize) throws IOException {
        TermDocs termDocs = reader.termDocs(term);
        TIntArrayList list = new TIntArrayList(expectedSize);
        try {
            while (termDocs.next()) {
                list.add(termDocs.doc());
            }
        }
        finally {
            termDocs.close();
        }
        return list;
    }

    public static boolean safeClose(IndexReader reader) {
        if (reader == null) {
            return true;
        }
        try {
            reader.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean safeClose(IndexWriter writer) {
        if (writer == null) {
            return true;
        }
        try {
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static TopDocs readTopDocs(StreamInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        if (in.readBoolean()) {
            int totalHits = in.readVInt();
            float maxScore = in.readFloat();
            SortField[] fields = new SortField[in.readVInt()];
            for (int i = 0; i < fields.length; ++i) {
                String field = null;
                if (in.readBoolean()) {
                    field = in.readUTF();
                }
                fields[i] = new SortField(field, in.readVInt(), in.readBoolean());
            }
            FieldDoc[] fieldDocs = new FieldDoc[in.readVInt()];
            for (int i = 0; i < fieldDocs.length; ++i) {
                Comparable[] cFields = new Comparable[in.readVInt()];
                for (int j = 0; j < cFields.length; ++j) {
                    byte type = in.readByte();
                    if (type == 0) {
                        cFields[j] = null;
                        continue;
                    }
                    if (type == 1) {
                        cFields[j] = in.readUTF();
                        continue;
                    }
                    if (type == 2) {
                        cFields[j] = Integer.valueOf(in.readInt());
                        continue;
                    }
                    if (type == 3) {
                        cFields[j] = Long.valueOf(in.readLong());
                        continue;
                    }
                    if (type == 4) {
                        cFields[j] = Float.valueOf(in.readFloat());
                        continue;
                    }
                    if (type == 5) {
                        cFields[j] = Double.valueOf(in.readDouble());
                        continue;
                    }
                    if (type == 6) {
                        cFields[j] = Byte.valueOf(in.readByte());
                        continue;
                    }
                    if (type == 7) {
                        cFields[j] = Short.valueOf(in.readShort());
                        continue;
                    }
                    if (type == 8) {
                        cFields[j] = Boolean.valueOf(in.readBoolean());
                        continue;
                    }
                    throw new IOException("Can't match type [" + type + "]");
                }
                fieldDocs[i] = new FieldDoc(in.readVInt(), in.readFloat(), cFields);
            }
            return new TopFieldDocs(totalHits, (ScoreDoc[])fieldDocs, fields, maxScore);
        }
        int totalHits = in.readVInt();
        float maxScore = in.readFloat();
        ScoreDoc[] scoreDocs = new ScoreDoc[in.readVInt()];
        for (int i = 0; i < scoreDocs.length; ++i) {
            scoreDocs[i] = new ScoreDoc(in.readVInt(), in.readFloat());
        }
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public static void writeTopDocs(StreamOutput out, TopDocs topDocs, int from) throws IOException {
        if (topDocs.scoreDocs.length - from < 0) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (topDocs instanceof TopFieldDocs) {
            out.writeBoolean(true);
            TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topFieldDocs.fields.length);
            for (SortField sortField : topFieldDocs.fields) {
                if (sortField.getField() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(sortField.getField());
                }
                out.writeVInt(sortField.getType());
                out.writeBoolean(sortField.getReverse());
            }
            out.writeVInt(topDocs.scoreDocs.length - from);
            int index = 0;
            for (ScoreDoc doc : topFieldDocs.scoreDocs) {
                if (index++ < from) continue;
                FieldDoc fieldDoc = (FieldDoc)doc;
                out.writeVInt(fieldDoc.fields.length);
                for (Comparable field : fieldDoc.fields) {
                    if (field == null) {
                        out.writeByte((byte)0);
                        continue;
                    }
                    Class<?> type = field.getClass();
                    if (type == String.class) {
                        out.writeByte((byte)1);
                        out.writeUTF((String)((Object)field));
                        continue;
                    }
                    if (type == Integer.class) {
                        out.writeByte((byte)2);
                        out.writeInt((Integer)field);
                        continue;
                    }
                    if (type == Long.class) {
                        out.writeByte((byte)3);
                        out.writeLong((Long)field);
                        continue;
                    }
                    if (type == Float.class) {
                        out.writeByte((byte)4);
                        out.writeFloat(((Float)field).floatValue());
                        continue;
                    }
                    if (type == Double.class) {
                        out.writeByte((byte)5);
                        out.writeDouble((Double)field);
                        continue;
                    }
                    if (type == Byte.class) {
                        out.writeByte((byte)6);
                        out.writeByte((Byte)field);
                        continue;
                    }
                    if (type == Short.class) {
                        out.writeByte((byte)7);
                        out.writeShort((Short)field);
                        continue;
                    }
                    if (type == Boolean.class) {
                        out.writeByte((byte)8);
                        out.writeBoolean((Boolean)field);
                        continue;
                    }
                    throw new IOException("Can't handle sort field value of type [" + type + "]");
                }
                out.writeVInt(doc.doc);
                out.writeFloat(doc.score);
            }
        } else {
            out.writeBoolean(false);
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topDocs.scoreDocs.length - from);
            int index = 0;
            for (ScoreDoc doc : topDocs.scoreDocs) {
                if (index++ < from) continue;
                out.writeVInt(doc.doc);
                out.writeFloat(doc.score);
            }
        }
    }

    public static Explanation readExplanation(StreamInput in) throws IOException {
        float value = in.readFloat();
        String description = in.readUTF();
        Explanation explanation = new Explanation(value, description);
        if (in.readBoolean()) {
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                explanation.addDetail(Lucene.readExplanation(in));
            }
        }
        return explanation;
    }

    public static void writeExplanation(StreamOutput out, Explanation explanation) throws IOException {
        out.writeFloat(explanation.getValue());
        out.writeUTF(explanation.getDescription());
        Explanation[] subExplanations = explanation.getDetails();
        if (subExplanations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(subExplanations.length);
            for (Explanation subExp : subExplanations) {
                Lucene.writeExplanation(out, subExp);
            }
        }
    }

    public static Object readFieldValue(StreamInput in) throws IOException {
        byte type = in.readByte();
        if (type == -1) {
            return null;
        }
        if (type == 0) {
            return in.readUTF();
        }
        if (type == 1) {
            return in.readInt();
        }
        if (type == 2) {
            return in.readLong();
        }
        if (type == 3) {
            return Float.valueOf(in.readFloat());
        }
        if (type == 4) {
            return in.readDouble();
        }
        if (type == 5) {
            return in.readBoolean();
        }
        if (type == 6) {
            int bytesSize = in.readVInt();
            byte[] value = new byte[bytesSize];
            in.readFully(value);
            return value;
        }
        if (type == 7) {
            int size = in.readVInt();
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(Lucene.readFieldValue(in));
            }
            return list;
        }
        if (type == 8) {
            int size = in.readVInt();
            Object[] list = new Object[size];
            for (int i = 0; i < size; ++i) {
                list[i] = Lucene.readFieldValue(in);
            }
            return list;
        }
        if (type == 9) {
            int size = in.readVInt();
            HashMap<String, Object> map = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                map.put(in.readUTF(), Lucene.readFieldValue(in));
            }
            return map;
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }

    public static void writeFieldValue(StreamOutput out, Object value) throws IOException {
        if (value == null) {
            out.writeByte((byte)-1);
            return;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            out.writeByte((byte)0);
            out.writeUTF((String)value);
        } else if (type == Integer.class) {
            out.writeByte((byte)1);
            out.writeInt((Integer)value);
        } else if (type == Long.class) {
            out.writeByte((byte)2);
            out.writeLong((Long)value);
        } else if (type == Float.class) {
            out.writeByte((byte)3);
            out.writeFloat(((Float)value).floatValue());
        } else if (type == Double.class) {
            out.writeByte((byte)4);
            out.writeDouble((Double)value);
        } else if (type == Boolean.class) {
            out.writeByte((byte)5);
            out.writeBoolean((Boolean)value);
        } else if (type == byte[].class) {
            out.writeByte((byte)6);
            out.writeVInt(((byte[])value).length);
            out.writeBytes((byte[])value);
        } else if (value instanceof List) {
            out.writeByte((byte)7);
            List list = (List)value;
            out.writeVInt(list.size());
            for (Object o : list) {
                Lucene.writeFieldValue(out, o);
            }
        } else if (value instanceof Object[]) {
            out.writeByte((byte)8);
            Object[] list = (Object[])value;
            out.writeVInt(list.length);
            for (Object o : list) {
                Lucene.writeFieldValue(out, o);
            }
        } else if (value instanceof Map) {
            out.writeByte((byte)9);
            Map map = (Map)value;
            out.writeVInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                out.writeUTF((String)entry.getKey());
                Lucene.writeFieldValue(out, entry.getValue());
            }
        } else {
            throw new IOException("Can't write type [" + type + "]");
        }
    }

    private Lucene() {
    }

    static {
        ANALYZER_VERSION = VERSION = Version.LUCENE_CURRENT;
        QUERYPARSER_VERSION = VERSION;
        STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, (Analyzer)new StandardAnalyzer(ANALYZER_VERSION));
        KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, (Analyzer)new KeywordAnalyzer());
    }

    public static class SingleScoreCollector
    extends Collector {
        private Scorer scorer;
        private float score;

        public float score() {
            return this.score;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.score = 0.0f;
            this.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            this.score = this.scorer.score();
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    public static class ExistsCollector
    extends Collector {
        private boolean exists;

        public boolean exists() {
            return this.exists;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.exists = false;
        }

        public void collect(int doc) throws IOException {
            this.exists = true;
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    public static class CountCollector
    extends Collector {
        private final float minScore;
        private Scorer scorer;
        private long count;

        public CountCollector(float minScore) {
            this.minScore = minScore;
        }

        public long count() {
            return this.count;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            if (this.scorer.score() > this.minScore) {
                ++this.count;
            }
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

