/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.analysis;

import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public class CharSequenceTermAttribute
implements CharSequence {
    private final TermAttribute termAtt;

    public CharSequenceTermAttribute(TermAttribute termAtt) {
        this.termAtt = termAtt;
    }

    @Override
    public int length() {
        return this.termAtt.termLength();
    }

    @Override
    public char charAt(int index) {
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.termAtt.termBuffer()[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start > this.length() || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.termAtt.termBuffer(), start, end - start);
    }
}

