/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.analysis.cz;

public class CzechStemmer {
    public int stem(char[] s, int len) {
        len = this.removeCase(s, len);
        len = this.removePossessives(s, len);
        len = this.normalize(s, len);
        return len;
    }

    private boolean endsWith(char[] s, int len, String suffix) {
        int suffixLen = suffix.length();
        if (suffixLen > len) {
            return false;
        }
        for (int i = suffixLen - 1; i >= 0; --i) {
            if (s[len - (suffixLen - i)] == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private int removeCase(char[] s, int len) {
        if (len > 7 && this.endsWith(s, len, "atech")) {
            return len - 5;
        }
        if (len > 6 && (this.endsWith(s, len, "\u011btem") || this.endsWith(s, len, "etem") || this.endsWith(s, len, "at\u016fm"))) {
            return len - 4;
        }
        if (len > 5 && (this.endsWith(s, len, "ech") || this.endsWith(s, len, "ich") || this.endsWith(s, len, "\u00edch") || this.endsWith(s, len, "\u00e9ho") || this.endsWith(s, len, "\u011bmi") || this.endsWith(s, len, "emi") || this.endsWith(s, len, "\u00e9mu") || this.endsWith(s, len, "\u011bte") || this.endsWith(s, len, "ete") || this.endsWith(s, len, "\u011bti") || this.endsWith(s, len, "eti") || this.endsWith(s, len, "\u00edho") || this.endsWith(s, len, "iho") || this.endsWith(s, len, "\u00edmi") || this.endsWith(s, len, "\u00edmu") || this.endsWith(s, len, "imu") || this.endsWith(s, len, "\u00e1ch") || this.endsWith(s, len, "ata") || this.endsWith(s, len, "aty") || this.endsWith(s, len, "\u00fdch") || this.endsWith(s, len, "ama") || this.endsWith(s, len, "ami") || this.endsWith(s, len, "ov\u00e9") || this.endsWith(s, len, "ovi") || this.endsWith(s, len, "\u00fdmi"))) {
            return len - 3;
        }
        if (len > 4 && (this.endsWith(s, len, "em") || this.endsWith(s, len, "es") || this.endsWith(s, len, "\u00e9m") || this.endsWith(s, len, "\u00edm") || this.endsWith(s, len, "\u016fm") || this.endsWith(s, len, "at") || this.endsWith(s, len, "\u00e1m") || this.endsWith(s, len, "os") || this.endsWith(s, len, "us") || this.endsWith(s, len, "\u00fdm") || this.endsWith(s, len, "mi") || this.endsWith(s, len, "ou"))) {
            return len - 2;
        }
        if (len > 3) {
            switch (s[len - 1]) {
                case 'a': 
                case 'e': 
                case 'i': 
                case 'o': 
                case 'u': 
                case 'y': 
                case '\u00e1': 
                case '\u00e9': 
                case '\u00ed': 
                case '\u00fd': 
                case '\u011b': 
                case '\u016f': {
                    return len - 1;
                }
            }
        }
        return len;
    }

    private int removePossessives(char[] s, int len) {
        if (len > 5 && (this.endsWith(s, len, "ov") || this.endsWith(s, len, "in") || this.endsWith(s, len, "\u016fv"))) {
            return len - 2;
        }
        return len;
    }

    private int normalize(char[] s, int len) {
        if (this.endsWith(s, len, "\u010dt")) {
            s[len - 2] = 99;
            s[len - 1] = 107;
            return len;
        }
        if (this.endsWith(s, len, "\u0161t")) {
            s[len - 2] = 115;
            s[len - 1] = 107;
            return len;
        }
        switch (s[len - 1]) {
            case 'c': 
            case '\u010d': {
                s[len - 1] = 107;
                return len;
            }
            case 'z': 
            case '\u017e': {
                s[len - 1] = 104;
                return len;
            }
        }
        if (len > 1 && s[len - 2] == 'e') {
            s[len - 2] = s[len - 1];
            return len - 1;
        }
        if (len > 2 && s[len - 2] == '\u016f') {
            s[len - 2] = 111;
            return len;
        }
        return len;
    }
}

