/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class NotDocIdSet
extends DocIdSet {
    private final DocIdSet set;
    private final int max;

    public NotDocIdSet(DocIdSet set, int max) {
        this.max = max;
        this.set = set;
    }

    public boolean isCacheable() {
        return false;
    }

    public DocIdSetIterator iterator() throws IOException {
        return new NotDocIdSetIterator();
    }

    class NotDocIdSetIterator
    extends DocIdSetIterator {
        int lastReturn = -1;
        private DocIdSetIterator it1 = null;
        private int innerDocid = -1;

        NotDocIdSetIterator() throws IOException {
            this.initialize();
        }

        private void initialize() throws IOException {
            this.it1 = NotDocIdSet.this.set.iterator();
            this.innerDocid = this.it1.nextDoc();
            if (this.innerDocid == Integer.MAX_VALUE) {
                this.it1 = null;
            }
        }

        public int docID() {
            return this.lastReturn;
        }

        public int nextDoc() throws IOException {
            return this.advance(0);
        }

        public int advance(int target) throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (target <= this.lastReturn) {
                target = this.lastReturn + 1;
            }
            if (this.it1 != null && this.innerDocid < target && (this.innerDocid = this.it1.advance(target)) == Integer.MAX_VALUE) {
                this.it1 = null;
            }
            while (this.it1 != null && this.innerDocid == target) {
                if (++target >= NotDocIdSet.this.max) {
                    this.lastReturn = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.innerDocid = this.it1.advance(target);
                if (this.innerDocid != Integer.MAX_VALUE) continue;
                this.it1 = null;
            }
            if (target >= NotDocIdSet.this.max) {
                this.lastReturn = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }
    }
}

