/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;

public class ExtendedIndexSearcher
extends IndexSearcher {
    public ExtendedIndexSearcher(IndexSearcher searcher) {
        super(searcher.getIndexReader());
        this.setSimilarity(searcher.getSimilarity());
    }

    public ExtendedIndexSearcher(IndexReader r) {
        super(r);
    }

    public IndexReader[] subReaders() {
        return this.subReaders;
    }

    public int[] docStarts() {
        return this.docStarts;
    }

    public int readerIndex(int doc) {
        int lo = 0;
        int hi = this.subReaders.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = this.docStarts[mid];
            if (doc < midValue) {
                hi = mid - 1;
                continue;
            }
            if (doc > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.subReaders.length && this.docStarts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }
}

