/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.util;

import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.util.ASTIterator;

public class ASTLinkedList
implements ASTIterator {
    private ASTNode firstASTNode;
    private ASTNode current;
    private ASTNode last;
    private int size;

    public ASTLinkedList() {
    }

    public ASTLinkedList(ASTIterator iter) {
        this.current = this.firstASTNode = iter.firstNode();
    }

    public ASTLinkedList(ASTNode firstASTNode) {
        this.current = this.firstASTNode = firstASTNode;
    }

    public ASTLinkedList(ASTNode firstASTNode, int size) {
        this.current = this.firstASTNode = firstASTNode;
        this.size = size;
    }

    public void addTokenNode(ASTNode astNode) {
        ++this.size;
        if (this.firstASTNode == null) {
            this.firstASTNode = this.current = astNode;
        } else {
            this.current = this.current.nextASTNode = astNode;
            this.last = this.current.nextASTNode;
        }
    }

    public void addTokenNode(ASTNode astNode, ASTNode token2) {
        this.size += 2;
        if (this.firstASTNode == null) {
            this.firstASTNode = astNode;
            this.current = astNode.nextASTNode = token2;
            this.last = astNode.nextASTNode;
        } else {
            this.current.nextASTNode = astNode;
            this.current = astNode.nextASTNode = token2;
            this.last = astNode.nextASTNode;
        }
    }

    public ASTNode firstNode() {
        return this.firstASTNode;
    }

    public boolean isSingleNode() {
        return this.size == 1 || this.size == 2 && this.firstASTNode.fields == -1;
    }

    public ASTNode firstNonSymbol() {
        if (this.firstASTNode.fields == -1) {
            return this.firstASTNode.nextASTNode;
        }
        return this.firstASTNode;
    }

    public void reset() {
        this.current = this.firstASTNode;
    }

    public boolean hasMoreNodes() {
        return this.current != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode nextNode() {
        if (this.current == null) {
            return null;
        }
        try {
            ASTNode aSTNode = this.current;
            return aSTNode;
        }
        finally {
            this.current = this.current.nextASTNode;
        }
    }

    public void skipNode() {
        if (this.current != null) {
            this.current = this.current.nextASTNode;
        }
    }

    public ASTNode peekNext() {
        if (this.current != null && this.current.nextASTNode != null) {
            return this.current.nextASTNode;
        }
        return null;
    }

    public ASTNode peekNode() {
        if (this.current == null) {
            return null;
        }
        return this.current;
    }

    public void removeToken() {
        if (this.current != null) {
            this.current = this.current.nextASTNode;
        }
    }

    public ASTNode peekLast() {
        return this.last;
    }

    public ASTNode nodesBack(int offset) {
        throw new RuntimeException("unimplemented");
    }

    public ASTNode nodesAhead(int offset) {
        if (this.current == null) {
            return null;
        }
        ASTNode cursor = null;
        for (int i = 0; i < offset; ++i) {
            cursor = this.current.nextASTNode;
            if (cursor != null) continue;
            return null;
        }
        return cursor;
    }

    public void back() {
        throw new RuntimeException("unimplemented");
    }

    public String showNodeChain() {
        throw new RuntimeException("unimplemented");
    }

    public int size() {
        return this.size;
    }

    public int index() {
        return -1;
    }

    public void setCurrentNode(ASTNode node) {
        this.current = node;
    }

    public void finish() {
        this.reset();
        ASTNode last = null;
        while (this.hasMoreNodes()) {
            ASTNode curr = this.nextNode();
            if (curr.isDiscard()) {
                if (last == null) {
                    last = this.firstASTNode = this.nextNode();
                    continue;
                }
                last.nextASTNode = this.nextNode();
                continue;
            }
            if (!this.hasMoreNodes()) break;
            last = curr;
        }
        this.last = last;
        this.reset();
    }
}

