/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class NetworkService
extends AbstractComponent {
    public static final String LOCAL = "#local#";
    private static final String GLOBAL_NETWORK_HOST_SETTING = "network.host";
    private static final String GLOBAL_NETWORK_BINDHOST_SETTING = "network.bind_host";
    private static final String GLOBAL_NETWORK_PUBLISHHOST_SETTING = "network.publish_host";
    private volatile ImmutableMap<String, CustomNameResolver> customNameResolvers = ImmutableMap.of();

    @Inject
    public NetworkService(Settings settings) {
        super(settings);
    }

    public void addCustomNameResolver(String name, CustomNameResolver customNameResolver) {
        this.customNameResolvers = MapBuilder.newMapBuilder().putAll(this.customNameResolvers).put(name, customNameResolver).immutableMap();
    }

    public InetAddress resolveBindHostAddress(String bindHost) throws IOException {
        return this.resolveBindHostAddress(bindHost, null);
    }

    public InetAddress resolveBindHostAddress(String bindHost, String defaultValue2) throws IOException {
        return this.resolveInetAddress(bindHost, this.settings.get(GLOBAL_NETWORK_BINDHOST_SETTING, this.settings.get(GLOBAL_NETWORK_HOST_SETTING)), defaultValue2);
    }

    public InetAddress resolvePublishHostAddress(String publishHost) throws IOException {
        InetAddress address = this.resolvePublishHostAddress(publishHost, null);
        if ((address == null || address.isAnyLocalAddress()) && (address = NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.StackType.IPv4)) == null && (address = NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.getIpStackType())) == null) {
            return NetworkUtils.getLocalAddress();
        }
        return address;
    }

    public InetAddress resolvePublishHostAddress(String publishHost, String defaultValue2) throws IOException {
        return this.resolveInetAddress(publishHost, this.settings.get(GLOBAL_NETWORK_PUBLISHHOST_SETTING, this.settings.get(GLOBAL_NETWORK_HOST_SETTING)), defaultValue2);
    }

    public InetAddress resolveInetAddress(String host, String defaultValue1, String defaultValue2) throws UnknownHostException, IOException {
        if (host == null) {
            host = defaultValue1;
        }
        if (host == null) {
            host = defaultValue2;
        }
        if (host == null) {
            return null;
        }
        if (host.startsWith("#") && host.endsWith("#") || host.startsWith("_") && host.endsWith("_")) {
            CustomNameResolver customNameResolver = this.customNameResolvers.get(host = host.substring(1, host.length() - 1));
            if (customNameResolver != null) {
                return customNameResolver.resolve();
            }
            if (host.equals("local")) {
                return NetworkUtils.getLocalAddress();
            }
            if (host.startsWith("non_loopback")) {
                if (host.toLowerCase().endsWith(":ipv4")) {
                    return NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.StackType.IPv4);
                }
                if (host.toLowerCase().endsWith(":ipv6")) {
                    return NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.StackType.IPv6);
                }
                return NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.getIpStackType());
            }
            List<NetworkInterface> allInterfs = NetworkUtils.getAllAvailableInterfaces();
            for (NetworkInterface ni : allInterfs) {
                if (!ni.isUp() || ni.isLoopback() || !host.equals(ni.getName()) && !host.equals(ni.getDisplayName())) continue;
                return NetworkUtils.getFirstNonLoopbackAddress(ni, NetworkUtils.getIpStackType());
            }
            throw new IOException("Failed to find network interface for [" + host + "]");
        }
        return InetAddress.getByName(host);
    }

    public static interface CustomNameResolver {
        public InetAddress resolve();
    }

    public static final class TcpSettings {
        public static final String TCP_NO_DELAY = "network.tcp.no_delay";
        public static final String TCP_KEEP_ALIVE = "network.tcp.keep_alive";
        public static final String TCP_REUSE_ADDRESS = "network.tcp.reuse_address";
        public static final String TCP_SEND_BUFFER_SIZE = "network.tcp.send_buffer_size";
        public static final String TCP_RECEIVE_BUFFER_SIZE = "network.tcp.receive_buffer_size";
        public static final String TCP_BLOCKING = "network.tcp.blocking";
        public static final String TCP_BLOCKING_SERVER = "network.tcp.blocking_server";
        public static final String TCP_BLOCKING_CLIENT = "network.tcp.blocking_client";
        public static final String TCP_CONNECT_TIMEOUT = "network.tcp.connect_timeout";
        public static final ByteSizeValue TCP_DEFAULT_SEND_BUFFER_SIZE = new ByteSizeValue(32L, ByteSizeUnit.KB);
        public static final ByteSizeValue TCP_DEFAULT_RECEIVE_BUFFER_SIZE = new ByteSizeValue(32L, ByteSizeUnit.KB);
        public static final TimeValue TCP_DEFAULT_CONNECT_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);
    }
}

