/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.impl.hash;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.elasticsearch.common.trove.impl.hash.TObjectHash;
import org.elasticsearch.common.trove.strategy.HashingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCustomObjectHash<T>
extends TObjectHash<T> {
    static final long serialVersionUID = 8766048185963756400L;
    protected HashingStrategy<T> strategy;

    public TCustomObjectHash() {
    }

    public TCustomObjectHash(HashingStrategy<T> strategy) {
        this.strategy = strategy;
    }

    public TCustomObjectHash(HashingStrategy<T> strategy, int initialCapacity) {
        super(initialCapacity);
        this.strategy = strategy;
    }

    public TCustomObjectHash(HashingStrategy<T> strategy, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.strategy = strategy;
    }

    @Override
    protected int hash(Object obj) {
        return this.strategy.computeHashCode(obj);
    }

    @Override
    protected boolean equals(Object one, Object two) {
        return this.strategy.equals(one, two);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeObject(this.strategy);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        this.strategy = (HashingStrategy)in.readObject();
    }
}

