/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.Beta;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.util.concurrent.AbstractCheckedFuture;
import org.elasticsearch.common.util.concurrent.AbstractListenableFuture;
import org.elasticsearch.common.util.concurrent.CheckedFuture;
import org.elasticsearch.common.util.concurrent.ExecutionList;
import org.elasticsearch.common.util.concurrent.ForwardingFuture;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.MoreExecutors;
import org.elasticsearch.common.util.concurrent.ThreadFactoryBuilder;
import org.elasticsearch.common.util.concurrent.UninterruptibleFuture;
import org.elasticsearch.common.util.concurrent.ValueFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Futures {
    private Futures() {
    }

    public static <V> UninterruptibleFuture<V> makeUninterruptible(final Future<V> future) {
        Preconditions.checkNotNull(future);
        if (future instanceof UninterruptibleFuture) {
            return (UninterruptibleFuture)future;
        }
        return new UninterruptibleFuture<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public V get(long originalTimeout, TimeUnit originalUnit) throws TimeoutException, ExecutionException {
                boolean interrupted = false;
                try {
                    long end = System.nanoTime() + originalUnit.toNanos(originalTimeout);
                    while (true) {
                        Object v;
                        try {
                            v = future.get(end - System.nanoTime(), TimeUnit.NANOSECONDS);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            continue;
                        }
                        return v;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            @Override
            public V get() throws ExecutionException {
                boolean interrupted = false;
                while (true) {
                    try {
                        Object v = future.get();
                        return v;
                    }
                    catch (InterruptedException ignored) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }

    public static <V> ListenableFuture<V> makeListenable(Future<V> future) {
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future);
    }

    static <V> ListenableFuture<V> makeListenable(Future<V> future, Executor executor) {
        Preconditions.checkNotNull(executor);
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future, executor);
    }

    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(Future<V> future, Function<Exception, X> mapper) {
        return new MappingCheckedFuture<V, X>(Futures.makeListenable(future), mapper);
    }

    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        ValueFuture<V> future = ValueFuture.create();
        future.set(value);
        return future;
    }

    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@Nullable V value) {
        ValueFuture<V> future = ValueFuture.create();
        future.set(value);
        return Futures.makeChecked(future, new Function<Exception, X>(){

            @Override
            public X apply(Exception e) {
                throw new AssertionError((Object)"impossible");
            }
        });
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        ValueFuture future = ValueFuture.create();
        future.setException(throwable);
        return future;
    }

    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(final X exception) {
        Preconditions.checkNotNull(exception);
        return Futures.makeChecked(Futures.immediateFailedFuture(exception), new Function<Exception, X>(){

            @Override
            public X apply(Exception e) {
                return exception;
            }
        });
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, Function<? super I, ? extends ListenableFuture<? extends O>> function) {
        return Futures.chain(input, function, MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, Function<? super I, ? extends ListenableFuture<? extends O>> function, Executor exec) {
        ChainingListenableFuture chain = new ChainingListenableFuture(function, input);
        input.addListener(chain, exec);
        return chain;
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> future, Function<? super I, ? extends O> function) {
        return Futures.compose(future, function, MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> future, final Function<? super I, ? extends O> function, Executor exec) {
        Preconditions.checkNotNull(function);
        Function wrapperFunction = new Function<I, ListenableFuture<O>>(){

            @Override
            public ListenableFuture<O> apply(I input) {
                Object output = function.apply(input);
                return Futures.immediateFuture(output);
            }
        };
        return Futures.chain(future, wrapperFunction, exec);
    }

    public static <I, O> Future<O> compose(final Future<I> future, final Function<? super I, ? extends O> function) {
        if (future instanceof ListenableFuture) {
            return Futures.compose((ListenableFuture)future, function);
        }
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(function);
        return new Future<O>(){
            private final Object lock = new Object();
            private boolean set = false;
            private O value = null;
            private ExecutionException exception = null;

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.apply(future.get());
            }

            @Override
            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.apply(future.get(timeout, unit));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private O apply(I raw) throws ExecutionException {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.set) {
                        try {
                            this.value = function.apply(raw);
                        }
                        catch (RuntimeException e) {
                            this.exception = new ExecutionException(e);
                        }
                        catch (Error e) {
                            this.exception = new ExecutionException(e);
                        }
                        this.set = true;
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return this.value;
                }
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenableFutureAdapter<V>
    extends ForwardingFuture<V>
    implements ListenableFuture<V> {
        private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ListenableFutureAdapter-thread-%d").build();
        private static final Executor defaultAdapterExecutor = Executors.newCachedThreadPool(threadFactory);
        private final Executor adapterExecutor;
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<V> delegate;

        ListenableFutureAdapter(Future<V> delegate) {
            this(delegate, defaultAdapterExecutor);
        }

        ListenableFutureAdapter(Future<V> delegate, Executor adapterExecutor) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.adapterExecutor = Preconditions.checkNotNull(adapterExecutor);
        }

        @Override
        protected Future<V> delegate() {
            return this.delegate;
        }

        @Override
        public void addListener(Runnable listener, Executor exec) {
            this.executionList.add(listener, exec);
            if (this.hasListeners.compareAndSet(false, true)) {
                if (this.delegate.isDone()) {
                    this.executionList.run();
                    return;
                }
                this.adapterExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            ListenableFutureAdapter.this.delegate.get();
                        }
                        catch (Error e) {
                            throw e;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IllegalStateException("Adapter thread interrupted!", e);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ListenableFutureAdapter.this.executionList.run();
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> delegate, Function<Exception, X> mapper) {
            super(delegate);
            this.mapper = Preconditions.checkNotNull(mapper);
        }

        @Override
        protected X mapException(Exception e) {
            return (X)((Exception)this.mapper.apply(e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainingListenableFuture<I, O>
    extends AbstractListenableFuture<O>
    implements Runnable {
        private Function<? super I, ? extends ListenableFuture<? extends O>> function;
        private ListenableFuture<? extends I> inputFuture;
        private volatile ListenableFuture<? extends O> outputFuture;
        private final BlockingQueue<Boolean> mayInterruptIfRunningChannel = new LinkedBlockingQueue<Boolean>(1);
        private final CountDownLatch outputCreated = new CountDownLatch(1);

        private ChainingListenableFuture(Function<? super I, ? extends ListenableFuture<? extends O>> function, ListenableFuture<? extends I> inputFuture) {
            this.function = Preconditions.checkNotNull(function);
            this.inputFuture = Preconditions.checkNotNull(inputFuture);
        }

        @Override
        public O get() throws InterruptedException, ExecutionException {
            if (!this.isDone()) {
                ListenableFuture<I> inputFuture = this.inputFuture;
                if (inputFuture != null) {
                    inputFuture.get();
                }
                this.outputCreated.await();
                ListenableFuture<O> outputFuture = this.outputFuture;
                if (outputFuture != null) {
                    outputFuture.get();
                }
            }
            return (O)super.get();
        }

        @Override
        public O get(long timeout, TimeUnit unit) throws TimeoutException, ExecutionException, InterruptedException {
            if (!this.isDone()) {
                long start;
                ListenableFuture<I> inputFuture;
                if (unit != TimeUnit.NANOSECONDS) {
                    timeout = TimeUnit.NANOSECONDS.convert(timeout, unit);
                    unit = TimeUnit.NANOSECONDS;
                }
                if ((inputFuture = this.inputFuture) != null) {
                    start = System.nanoTime();
                    inputFuture.get(timeout, unit);
                    timeout -= Math.max(0L, System.nanoTime() - start);
                }
                start = System.nanoTime();
                if (!this.outputCreated.await(timeout, unit)) {
                    throw new TimeoutException();
                }
                timeout -= Math.max(0L, System.nanoTime() - start);
                ListenableFuture<O> outputFuture = this.outputFuture;
                if (outputFuture != null) {
                    outputFuture.get(timeout, unit);
                }
            }
            return (O)super.get(timeout, unit);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.cancel()) {
                try {
                    this.mayInterruptIfRunningChannel.put(mayInterruptIfRunning);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                this.cancel(this.inputFuture, mayInterruptIfRunning);
                this.cancel(this.outputFuture, mayInterruptIfRunning);
                return true;
            }
            return false;
        }

        private void cancel(@Nullable Future<?> future, boolean mayInterruptIfRunning) {
            if (future != null) {
                future.cancel(mayInterruptIfRunning);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block18: {
                try {
                    I sourceResult;
                    try {
                        sourceResult = Futures.makeUninterruptible(this.inputFuture).get();
                    }
                    catch (CancellationException e) {
                        this.cancel();
                        this.function = null;
                        this.inputFuture = null;
                        this.outputCreated.countDown();
                        return;
                    }
                    catch (ExecutionException e) {
                        this.setException(e.getCause());
                        this.function = null;
                        this.inputFuture = null;
                        this.outputCreated.countDown();
                        return;
                    }
                    this.outputFuture = this.function.apply(sourceResult);
                    final ListenableFuture<O> outputFuture = this.outputFuture;
                    if (this.isCancelled()) {
                        try {
                            outputFuture.cancel(this.mayInterruptIfRunningChannel.take());
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                        this.outputFuture = null;
                        return;
                    }
                    outputFuture.addListener(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                ChainingListenableFuture.this.set(Futures.makeUninterruptible(outputFuture).get());
                            }
                            catch (CancellationException e) {
                                ChainingListenableFuture.this.cancel();
                                return;
                            }
                            catch (ExecutionException e) {
                                ChainingListenableFuture.this.setException(e.getCause());
                            }
                            finally {
                                ChainingListenableFuture.this.outputFuture = null;
                            }
                        }
                    }, MoreExecutors.sameThreadExecutor());
                    break block18;
                    {
                        catch (UndeclaredThrowableException e) {
                            this.setException(e.getCause());
                            break block18;
                        }
                        catch (RuntimeException e) {
                            this.setException(e);
                            break block18;
                        }
                        catch (Error e) {
                            this.setException(e);
                            break block18;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.function = null;
                    this.inputFuture = null;
                    this.outputCreated.countDown();
                }
            }
        }
    }
}

