/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.discovery.DiscoveryException;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.ZenPingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.VoidTransportResponseHandler;

public class MulticastZenPing
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    private final String address;
    private final int port;
    private final String group;
    private final int bufferSize;
    private final int ttl;
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterName clusterName;
    private final NetworkService networkService;
    private volatile DiscoveryNodesProvider nodesProvider;
    private volatile Receiver receiver;
    private volatile Thread receiverThread;
    private MulticastSocket multicastSocket;
    private DatagramPacket datagramPacketSend;
    private DatagramPacket datagramPacketReceive;
    private final AtomicInteger pingIdGenerator = new AtomicInteger();
    private final Map<Integer, ConcurrentMap<DiscoveryNode, ZenPing.PingResponse>> receivedResponses = ConcurrentCollections.newConcurrentMap();
    private final Object sendMutex = new Object();
    private final Object receiveMutex = new Object();

    public MulticastZenPing(ThreadPool threadPool, TransportService transportService, ClusterName clusterName) {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, threadPool, transportService, clusterName, new NetworkService(ImmutableSettings.Builder.EMPTY_SETTINGS));
    }

    public MulticastZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, NetworkService networkService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = clusterName;
        this.networkService = networkService;
        this.address = this.componentSettings.get("address");
        this.port = this.componentSettings.getAsInt("port", 54328);
        this.group = this.componentSettings.get("group", "224.2.2.4");
        this.bufferSize = this.componentSettings.getAsInt("buffer_size", 2048);
        this.ttl = this.componentSettings.getAsInt("ttl", 3);
        this.logger.debug("using group [{}], with port [{}], ttl [{}], and address [{}]", this.group, this.port, this.ttl, this.address);
        this.transportService.registerHandler("discovery/zen/multicast", new MulticastPingResponseRequestHandler());
    }

    @Override
    public void setNodesProvider(DiscoveryNodesProvider nodesProvider) {
        if (this.lifecycle.started()) {
            throw new ElasticSearchIllegalStateException("Can't set nodes provider when started");
        }
        this.nodesProvider = nodesProvider;
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        try {
            this.datagramPacketReceive = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
            this.datagramPacketSend = new DatagramPacket(new byte[this.bufferSize], this.bufferSize, InetAddress.getByName(this.group), this.port);
        }
        catch (Exception e) {
            throw new DiscoveryException("Failed to set datagram packets", e);
        }
        try {
            MulticastSocket multicastSocket = new MulticastSocket(this.port);
            multicastSocket.setTimeToLive(this.ttl);
            InetAddress multicastInterface = this.networkService.resolvePublishHostAddress(this.address);
            multicastSocket.setInterface(multicastInterface);
            multicastSocket.joinGroup(InetAddress.getByName(this.group));
            multicastSocket.setReceiveBufferSize(this.bufferSize);
            multicastSocket.setSendBufferSize(this.bufferSize);
            multicastSocket.setSoTimeout(60000);
            this.multicastSocket = multicastSocket;
        }
        catch (Exception e) {
            throw new DiscoveryException("Failed to setup multicast socket", e);
        }
        this.receiver = new Receiver();
        this.receiverThread = EsExecutors.daemonThreadFactory(this.settings, "discovery#multicast#received").newThread(this.receiver);
        this.receiverThread.start();
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.receiver.stop();
        this.receiverThread.interrupt();
        this.multicastSocket.close();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.ping(new ZenPing.PingListener(){

            @Override
            public void onPing(ZenPing.PingResponse[] pings) {
                response.set(pings);
                latch.countDown();
            }
        }, timeout);
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void ping(final ZenPing.PingListener listener, TimeValue timeout) {
        final int id = this.pingIdGenerator.incrementAndGet();
        this.receivedResponses.put(id, new ConcurrentHashMap());
        this.sendPingRequest(id, true);
        this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 2L), "cached", new Runnable(){

            @Override
            public void run() {
                try {
                    MulticastZenPing.this.sendPingRequest(id, false);
                }
                catch (Exception e) {
                    MulticastZenPing.this.logger.warn("[{}] failed to send second ping request", e, id);
                }
            }
        });
        this.threadPool.schedule(timeout, "cached", new Runnable(){

            @Override
            public void run() {
                ConcurrentMap responses = (ConcurrentMap)MulticastZenPing.this.receivedResponses.remove(id);
                listener.onPing(responses.values().toArray(new ZenPing.PingResponse[responses.size()]));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingRequest(int id, boolean remove) {
        Object object = this.sendMutex;
        synchronized (object) {
            try {
                HandlesStreamOutput out = CachedStreamOutput.cachedHandlesBytes();
                out.writeInt(id);
                this.clusterName.writeTo(out);
                this.nodesProvider.nodes().localNode().writeTo(out);
                this.datagramPacketSend.setData(((BytesStreamOutput)out.wrappedOut()).copiedByteArray());
            }
            catch (IOException e) {
                if (remove) {
                    this.receivedResponses.remove(id);
                }
                throw new ZenPingException("Failed to serialize ping request", e);
            }
            try {
                this.multicastSocket.send(this.datagramPacketSend);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[{}] sending ping request", id);
                }
            }
            catch (IOException e) {
                if (remove) {
                    this.receivedResponses.remove(id);
                }
                throw new ZenPingException("Failed to send ping request over multicast on " + this.multicastSocket, e);
            }
        }
    }

    private class Receiver
    implements Runnable {
        private volatile boolean running = true;

        private Receiver() {
        }

        public void stop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    DiscoveryNode requestingNodeX;
                    ClusterName clusterName;
                    int id;
                    Object object = MulticastZenPing.this.receiveMutex;
                    synchronized (object) {
                        try {
                            MulticastZenPing.this.multicastSocket.receive(MulticastZenPing.this.datagramPacketReceive);
                        }
                        catch (SocketTimeoutException ignore) {
                            continue;
                        }
                        catch (Exception e) {
                            if (this.running) {
                                MulticastZenPing.this.logger.warn("failed to receive packet", e, new Object[0]);
                            }
                            continue;
                        }
                        try {
                            HandlesStreamInput input = CachedStreamInput.cachedHandles(new BytesStreamInput(MulticastZenPing.this.datagramPacketReceive.getData(), MulticastZenPing.this.datagramPacketReceive.getOffset(), MulticastZenPing.this.datagramPacketReceive.getLength()));
                            id = input.readInt();
                            clusterName = ClusterName.readClusterName(input);
                            requestingNodeX = DiscoveryNode.readNode(input);
                        }
                        catch (Exception e) {
                            MulticastZenPing.this.logger.warn("failed to read requesting node from {}", e, MulticastZenPing.this.datagramPacketReceive.getSocketAddress());
                            continue;
                        }
                    }
                    DiscoveryNodes discoveryNodes = MulticastZenPing.this.nodesProvider.nodes();
                    final DiscoveryNode requestingNode = requestingNodeX;
                    if (requestingNode.id().equals(discoveryNodes.localNodeId()) || !clusterName.equals(MulticastZenPing.this.clusterName)) continue;
                    final MulticastPingResponse multicastPingResponse = new MulticastPingResponse();
                    multicastPingResponse.id = id;
                    multicastPingResponse.pingResponse = new ZenPing.PingResponse(discoveryNodes.localNode(), discoveryNodes.masterNode(), clusterName);
                    if (MulticastZenPing.this.logger.isTraceEnabled()) {
                        MulticastZenPing.this.logger.trace("[{}] received ping_request from [{}], sending {}", id, requestingNode, multicastPingResponse.pingResponse);
                    }
                    if (!MulticastZenPing.this.transportService.nodeConnected(requestingNode)) {
                        MulticastZenPing.this.threadPool.cached().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    MulticastZenPing.this.transportService.connectToNode(requestingNode);
                                    MulticastZenPing.this.transportService.sendRequest(requestingNode, "discovery/zen/multicast", multicastPingResponse, new VoidTransportResponseHandler("same"){

                                        @Override
                                        public void handleException(TransportException exp) {
                                            MulticastZenPing.this.logger.warn("failed to receive confirmation on sent ping response to [{}]", exp, requestingNode);
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    MulticastZenPing.this.logger.warn("failed to connect to requesting node {}", e, requestingNode);
                                }
                            }
                        });
                        continue;
                    }
                    MulticastZenPing.this.transportService.sendRequest(requestingNode, "discovery/zen/multicast", multicastPingResponse, new VoidTransportResponseHandler("same"){

                        @Override
                        public void handleException(TransportException exp) {
                            MulticastZenPing.this.logger.warn("failed to receive confirmation on sent ping response to [{}]", exp, requestingNode);
                        }
                    });
                }
                catch (Exception e) {
                    MulticastZenPing.this.logger.warn("unexpected exception in multicast receiver", e, new Object[0]);
                }
            }
        }
    }

    static class MulticastPingResponse
    implements Streamable {
        int id;
        ZenPing.PingResponse pingResponse;

        MulticastPingResponse() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.id = in.readInt();
            this.pingResponse = ZenPing.PingResponse.readPingResponse(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.id);
            this.pingResponse.writeTo(out);
        }
    }

    class MulticastPingResponseRequestHandler
    extends BaseTransportRequestHandler<MulticastPingResponse> {
        static final String ACTION = "discovery/zen/multicast";

        MulticastPingResponseRequestHandler() {
        }

        @Override
        public MulticastPingResponse newInstance() {
            return new MulticastPingResponse();
        }

        @Override
        public void messageReceived(MulticastPingResponse request, TransportChannel channel) throws Exception {
            ConcurrentMap responses;
            if (MulticastZenPing.this.logger.isTraceEnabled()) {
                MulticastZenPing.this.logger.trace("[{}] received {}", request.id, request.pingResponse);
            }
            if ((responses = (ConcurrentMap)MulticastZenPing.this.receivedResponses.get(request.id)) == null) {
                MulticastZenPing.this.logger.warn("received ping response with no matching id [{}]", request.id);
            } else {
                responses.put(request.pingResponse.target(), request.pingResponse);
            }
            channel.sendResponse(VoidStreamable.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

