/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.blobstore;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.shared.SharedStorageGateway;
import org.elasticsearch.index.gateway.CommitPoint;
import org.elasticsearch.index.gateway.CommitPoints;
import org.elasticsearch.index.gateway.blobstore.BlobStoreIndexGateway;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class BlobStoreGateway
extends SharedStorageGateway {
    private BlobStore blobStore;
    private ByteSizeValue chunkSize;
    private BlobPath basePath;
    private ImmutableBlobContainer metaDataBlobContainer;
    private volatile int currentIndex;

    protected BlobStoreGateway(Settings settings, ThreadPool threadPool, ClusterService clusterService) {
        super(settings, threadPool, clusterService);
    }

    protected void initialize(BlobStore blobStore, ClusterName clusterName, @Nullable ByteSizeValue defaultChunkSize) throws IOException {
        this.blobStore = blobStore;
        this.chunkSize = this.componentSettings.getAsBytesSize("chunk_size", defaultChunkSize);
        this.basePath = BlobPath.cleanPath().add(clusterName.value());
        this.metaDataBlobContainer = blobStore.immutableBlobContainer(this.basePath.add("metadata"));
        this.currentIndex = this.findLatestIndex();
        this.logger.debug("Latest metadata found at index [" + this.currentIndex + "]", new Object[0]);
    }

    public String toString() {
        return this.type() + "://" + this.blobStore + "/" + this.basePath;
    }

    public BlobStore blobStore() {
        return this.blobStore;
    }

    public BlobPath basePath() {
        return this.basePath;
    }

    public ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    @Override
    public void reset() throws Exception {
        this.blobStore.delete(BlobPath.cleanPath());
    }

    @Override
    public MetaData read() throws GatewayException {
        try {
            this.currentIndex = this.findLatestIndex();
        }
        catch (IOException e) {
            throw new GatewayException("Failed to find latest metadata to read from", e);
        }
        if (this.currentIndex == -1) {
            return null;
        }
        String metaData = "metadata-" + this.currentIndex;
        try {
            return this.readMetaData(this.metaDataBlobContainer.readBlobFully(metaData));
        }
        catch (GatewayException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GatewayException("Failed to read metadata [" + metaData + "] from gateway", e);
        }
    }

    public CommitPoint findCommitPoint(String index, int shardId) throws IOException {
        BlobPath path = BlobStoreIndexGateway.shardPath(this.basePath, index, shardId);
        ImmutableBlobContainer container = this.blobStore.immutableBlobContainer(path);
        ImmutableMap<String, BlobMetaData> blobs = container.listBlobs();
        ArrayList<CommitPoint> commitPointsList = Lists.newArrayList();
        for (BlobMetaData md : blobs.values()) {
            if (md.length() == 0L || !md.name().startsWith("commit-")) continue;
            try {
                commitPointsList.add(CommitPoints.fromXContent(container.readBlobFully(md.name())));
            }
            catch (Exception e) {
                this.logger.warn("failed to read commit point at path {} with name [{}]", e, path, md.name());
            }
        }
        CommitPoints commitPoints = new CommitPoints(commitPointsList);
        if (commitPoints.commits().isEmpty()) {
            return null;
        }
        return (CommitPoint)commitPoints.commits().get(0);
    }

    @Override
    public void write(MetaData metaData) throws GatewayException {
        XContentBuilder builder;
        final String newMetaData = "metadata-" + (this.currentIndex + 1);
        try {
            builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.prettyPrint();
            builder.startObject();
            MetaData.Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
        }
        catch (IOException e) {
            throw new GatewayException("Failed to serialize metadata into gateway", e);
        }
        try {
            this.metaDataBlobContainer.writeBlob(newMetaData, new ByteArrayInputStream(builder.unsafeBytes(), 0, builder.unsafeBytesLength()), builder.unsafeBytesLength());
        }
        catch (IOException e) {
            throw new GatewayException("Failed to write metadata [" + newMetaData + "]", e);
        }
        ++this.currentIndex;
        try {
            this.metaDataBlobContainer.deleteBlobsByFilter(new BlobContainer.BlobNameFilter(){

                @Override
                public boolean accept(String blobName) {
                    return blobName.startsWith("metadata-") && !newMetaData.equals(blobName);
                }
            });
        }
        catch (IOException e) {
            this.logger.debug("Failed to delete old metadata, will do it next time", e, new Object[0]);
        }
    }

    private int findLatestIndex() throws IOException {
        ImmutableMap<String, BlobMetaData> blobs = this.metaDataBlobContainer.listBlobsByPrefix("metadata-");
        int index = -1;
        for (BlobMetaData md : blobs.values()) {
            String name;
            int fileIndex;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[findLatestMetadata]: Processing [" + md.name() + "]", new Object[0]);
            }
            if ((fileIndex = Integer.parseInt((name = md.name()).substring(name.indexOf(45) + 1))) < index) continue;
            try {
                this.readMetaData(this.metaDataBlobContainer.readBlobFully(name));
                index = fileIndex;
            }
            catch (IOException e) {
                this.logger.warn("[findLatestMetadata]: Failed to read metadata from [" + name + "], ignoring...", e, new Object[0]);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaData readMetaData(byte[] data) throws IOException {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(XContentType.JSON).createParser(data);
            MetaData metaData = MetaData.Builder.fromXContent(parser);
            return metaData;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }
}

