/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.WordlistLoader;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.settings.Settings;

public class Analysis {
    public static boolean isNoStopwords(Settings settings) {
        String value = settings.get("stopwords");
        return value != null && "_none_".equals(value);
    }

    public static Set<?> parseStopWords(Settings settings, Set<?> defaultStopWords) {
        String value = settings.get("stopwords");
        if (value != null) {
            if ("_none_".equals(value)) {
                return ImmutableSet.of();
            }
            return ImmutableSet.copyOf(Strings.commaDelimitedListToSet(value));
        }
        String[] stopWords = settings.getAsArray("stopwords", null);
        if (stopWords != null) {
            return ImmutableSet.copyOf(Iterators.forArray(stopWords));
        }
        return defaultStopWords;
    }

    public static Set<String> getWordList(Settings settings, String settingPrefix) {
        String wordListPath = settings.get(settingPrefix + "_path", null);
        if (wordListPath == null) {
            String[] explicitWordList = settings.getAsArray(settingPrefix, null);
            if (explicitWordList == null) {
                String message = String.format("%s or %s_path must be provided.", settingPrefix, settingPrefix);
                throw new ElasticSearchIllegalArgumentException(message);
            }
            return new HashSet<String>(Arrays.asList(explicitWordList));
        }
        File wordListFile = new File(wordListPath);
        if (!wordListFile.exists()) {
            throw new ElasticSearchIllegalArgumentException(settingPrefix + "_path file must exist.");
        }
        try {
            return WordlistLoader.getWordSet((File)wordListFile);
        }
        catch (IOException ioe) {
            String message = String.format("IOException while reading %s_path: %s", settingPrefix, ioe.getMessage());
            throw new ElasticSearchIllegalArgumentException(message);
        }
    }
}

