/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class BrazilianAnalyzerProvider
extends AbstractIndexAnalyzerProvider<BrazilianAnalyzer> {
    private final Set<?> stemExclusion;
    private final BrazilianAnalyzer analyzer;

    @Inject
    public BrazilianAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        Set<?> stopWords = Analysis.parseStopWords(settings, BrazilianAnalyzer.getDefaultStopSet());
        String[] stemExclusion = settings.getAsArray("stem_exclusion");
        this.stemExclusion = stemExclusion.length > 0 ? ImmutableSet.copyOf(Iterators.forArray(stemExclusion)) : ImmutableSet.of();
        this.analyzer = new BrazilianAnalyzer(Lucene.ANALYZER_VERSION, stopWords, this.stemExclusion);
    }

    @Override
    public BrazilianAnalyzer get() {
        return this.analyzer;
    }
}

