/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class EdgeNGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int minGram;
    private final int maxGram;
    private final EdgeNGramTokenFilter.Side side;

    @Inject
    public EdgeNGramTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        this.minGram = settings.getAsInt("min_gram", 1);
        this.maxGram = settings.getAsInt("max_gram", 2);
        this.side = EdgeNGramTokenFilter.Side.getSide((String)settings.get("side", EdgeNGramTokenizer.DEFAULT_SIDE.getLabel()));
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new EdgeNGramTokenFilter(tokenStream, this.side, this.minGram, this.maxGram);
    }
}

