/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PatternAnalyzer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class PatternAnalyzerProvider
extends AbstractIndexAnalyzerProvider<PatternAnalyzer> {
    private final PatternAnalyzer analyzer;

    @Inject
    public PatternAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        boolean lowercase = settings.getAsBoolean("lowercase", true);
        Set<?> stopWords = Analysis.parseStopWords(settings, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new ElasticSearchIllegalArgumentException("Analyzer [" + name + "] of type pattern must have a `pattern` set");
        }
        Pattern pattern = Regex.compile(sPattern, settings.get("flags"));
        this.analyzer = new PatternAnalyzer(Lucene.ANALYZER_VERSION, pattern, lowercase, stopWords);
    }

    @Override
    public PatternAnalyzer get() {
        return this.analyzer;
    }
}

