/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.HtmlStripCharFilterFactory;
import org.elasticsearch.index.analysis.LowerCaseTokenFilterFactory;
import org.elasticsearch.index.analysis.StandardTokenFilterFactory;
import org.elasticsearch.index.analysis.StandardTokenizerFactory;
import org.elasticsearch.index.analysis.StopTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class StandardHtmlStripAnalyzerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final CustomAnalyzer analyzer;

    @Inject
    public StandardHtmlStripAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        this.analyzer = new CustomAnalyzer(new StandardTokenizerFactory(index, indexSettings, name, settings), new CharFilterFactory[]{new HtmlStripCharFilterFactory(index, indexSettings, name, settings)}, new TokenFilterFactory[]{new StandardTokenFilterFactory(index, indexSettings, name, settings), new LowerCaseTokenFilterFactory(index, indexSettings, name, settings), new StopTokenFilterFactory(index, indexSettings, name, settings)});
    }

    @Override
    public CustomAnalyzer get() {
        return this.analyzer;
    }
}

