/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.field.data.none;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.settings.IndexSettings;

public class NoneFieldDataCache
extends AbstractIndexComponent
implements FieldDataCache {
    @Inject
    public NoneFieldDataCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.logger.debug("Using no field cache", new Object[0]);
    }

    @Override
    public FieldData cache(FieldDataType type, IndexReader reader, String fieldName) throws IOException {
        return FieldData.load(type, reader, fieldName);
    }

    @Override
    public String type() {
        return "none";
    }

    @Override
    public void clear() {
    }

    @Override
    public void clear(IndexReader reader) {
    }

    @Override
    public void clearUnreferenced() {
    }

    @Override
    public void close() throws ElasticSearchException {
    }

    @Override
    public long sizeInBytes() {
        return 0L;
    }

    @Override
    public long sizeInBytes(String fieldName) {
        return 0L;
    }

    @Override
    public long evictions() {
        return 0L;
    }
}

