/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.field.data.soft;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.MapEvictionListener;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.field.data.support.AbstractConcurrentMapFieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.settings.IndexSettings;

public class SoftFieldDataCache
extends AbstractConcurrentMapFieldDataCache
implements MapEvictionListener<String, FieldData> {
    private final AtomicLong evictions = new AtomicLong();

    @Inject
    public SoftFieldDataCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    protected ConcurrentMap<String, FieldData> buildFieldDataMap() {
        return new MapMaker().softValues().evictionListener(this).makeMap();
    }

    @Override
    public long evictions() {
        return this.evictions.get();
    }

    @Override
    public String type() {
        return "soft";
    }

    @Override
    public void onEviction(@Nullable String s, @Nullable FieldData fieldData) {
        this.evictions.incrementAndGet();
    }
}

