/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.resident;

import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.support.AbstractDoubleConcurrentMapFilterCache;
import org.elasticsearch.index.settings.IndexSettings;

public class ResidentFilterCache
extends AbstractDoubleConcurrentMapFilterCache {
    private final int maxSize;

    @Inject
    public ResidentFilterCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.maxSize = this.componentSettings.getAsInt("max_size", 1000);
    }

    @Override
    protected ConcurrentMap<Filter, DocSet> buildCacheMap() {
        MapMaker mapMaker = new MapMaker();
        if (this.maxSize != -1) {
            mapMaker.maximumSize(this.maxSize);
        }
        return mapMaker.makeMap();
    }

    @Override
    protected ConcurrentMap<Filter, DocSet> buildWeakCacheMap() {
        MapMaker mapMaker = new MapMaker().weakValues();
        if (this.maxSize != -1) {
            mapMaker.maximumSize(this.maxSize);
        }
        return mapMaker.makeMap();
    }

    @Override
    public String type() {
        return "soft";
    }
}

