/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.support;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractDoubleConcurrentMapFilterCache
extends AbstractIndexComponent
implements FilterCache {
    final ConcurrentMap<Object, ConcurrentMap<Filter, DocSet>> cache = new MapMaker().weakKeys().makeMap();
    final ConcurrentMap<Object, ConcurrentMap<Filter, DocSet>> weakCache = new MapMaker().weakKeys().makeMap();

    protected AbstractDoubleConcurrentMapFilterCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.weakCache.clear();
    }

    @Override
    public void clear(IndexReader reader) {
        ConcurrentMap map = (ConcurrentMap)this.cache.remove(reader.getFieldCacheKey());
        if (map != null) {
            map.clear();
        }
        if ((map = (ConcurrentMap)this.weakCache.remove(reader.getFieldCacheKey())) != null) {
            map.clear();
        }
    }

    @Override
    public void clearUnreferenced() {
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes = 0L;
        for (ConcurrentMap map : this.cache.values()) {
            for (DocSet docSet : map.values()) {
                sizeInBytes += docSet.sizeInBytes();
            }
        }
        for (ConcurrentMap map : this.weakCache.values()) {
            for (DocSet docSet : map.values()) {
                sizeInBytes += docSet.sizeInBytes();
            }
        }
        return sizeInBytes;
    }

    @Override
    public Filter cache(Filter filterToCache) {
        if (this.isCached(filterToCache)) {
            return filterToCache;
        }
        return new FilterCacheFilterWrapper(filterToCache, this);
    }

    @Override
    public Filter weakCache(Filter filterToCache) {
        if (this.isCached(filterToCache)) {
            return filterToCache;
        }
        return new FilterWeakCacheFilterWrapper(filterToCache, this);
    }

    @Override
    public boolean isCached(Filter filter) {
        return filter instanceof CacheMarker;
    }

    protected ConcurrentMap<Filter, DocSet> buildCacheMap() {
        return ConcurrentCollections.newConcurrentMap();
    }

    protected ConcurrentMap<Filter, DocSet> buildWeakCacheMap() {
        return ConcurrentCollections.newConcurrentMap();
    }

    static class FilterWeakCacheFilterWrapper
    extends CacheMarker {
        private final Filter filter;
        private final AbstractDoubleConcurrentMapFilterCache cache;

        FilterWeakCacheFilterWrapper(Filter filter, AbstractDoubleConcurrentMapFilterCache cache) {
            this.filter = filter;
            this.cache = cache;
        }

        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            DocSet docSet;
            ConcurrentMap cachedFilters = (ConcurrentMap)this.cache.cache.get(reader.getFieldCacheKey());
            if (cachedFilters != null && (docSet = (DocSet)((Object)cachedFilters.get(this.filter))) != null) {
                return docSet;
            }
            ConcurrentMap<Filter, DocSet> weakCacheFilters = (ConcurrentMap<Filter, DocSet>)this.cache.weakCache.get(reader.getFieldCacheKey());
            if (weakCacheFilters == null) {
                weakCacheFilters = this.cache.buildWeakCacheMap();
                ConcurrentMap<Filter, DocSet> prev = this.cache.weakCache.putIfAbsent(reader.getFieldCacheKey(), weakCacheFilters);
                if (prev != null) {
                    weakCacheFilters = prev;
                }
            }
            if ((docSet = (DocSet)((Object)weakCacheFilters.get(this.filter))) != null) {
                return docSet;
            }
            DocIdSet docIdSet = this.filter.getDocIdSet(reader);
            docSet = DocSets.cacheable(reader, docIdSet);
            DocSet prev = weakCacheFilters.putIfAbsent(this.filter, docSet);
            if (prev != null) {
                docSet = prev;
            }
            return docSet;
        }

        public String toString() {
            return "FilterCacheFilterWrapper(" + this.filter + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof FilterCacheFilterWrapper)) {
                return false;
            }
            return this.filter.equals(((FilterCacheFilterWrapper)((Object)o)).filter);
        }

        public int hashCode() {
            return this.filter.hashCode() ^ 0x1117BF25;
        }
    }

    static class FilterCacheFilterWrapper
    extends CacheMarker {
        private final Filter filter;
        private final AbstractDoubleConcurrentMapFilterCache cache;

        FilterCacheFilterWrapper(Filter filter, AbstractDoubleConcurrentMapFilterCache cache) {
            this.filter = filter;
            this.cache = cache;
        }

        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            DocSet docSet;
            ConcurrentMap<Filter, DocSet> cachedFilters = (ConcurrentMap<Filter, DocSet>)this.cache.cache.get(reader.getFieldCacheKey());
            if (cachedFilters == null) {
                cachedFilters = this.cache.buildCacheMap();
                ConcurrentMap<Filter, DocSet> prev = this.cache.cache.putIfAbsent(reader.getFieldCacheKey(), cachedFilters);
                if (prev != null) {
                    cachedFilters = prev;
                }
            }
            if ((docSet = (DocSet)((Object)cachedFilters.get(this.filter))) != null) {
                return docSet;
            }
            DocIdSet docIdSet = this.filter.getDocIdSet(reader);
            docSet = DocSets.cacheable(reader, docIdSet);
            DocSet prev = cachedFilters.putIfAbsent(this.filter, docSet);
            if (prev != null) {
                docSet = prev;
            }
            return docSet;
        }

        public String toString() {
            return "FilterCacheFilterWrapper(" + this.filter + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof FilterCacheFilterWrapper)) {
                return false;
            }
            return this.filter.equals(((FilterCacheFilterWrapper)((Object)o)).filter);
        }

        public int hashCode() {
            return this.filter.hashCode() ^ 0x1117BF25;
        }
    }

    static abstract class CacheMarker
    extends Filter {
        CacheMarker() {
        }
    }
}

