/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.weak;

import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.support.AbstractConcurrentMapFilterCache;
import org.elasticsearch.index.settings.IndexSettings;

public class WeakFilterCache
extends AbstractConcurrentMapFilterCache {
    private final int maxSize;

    @Inject
    public WeakFilterCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.maxSize = this.componentSettings.getAsInt("max_size", -1);
    }

    @Override
    protected ConcurrentMap<Filter, DocSet> buildFilterMap() {
        MapMaker mapMaker = new MapMaker().weakValues();
        if (this.maxSize != -1) {
            mapMaker.maximumSize(this.maxSize);
        }
        return mapMaker.makeMap();
    }

    @Override
    public String type() {
        return "weak";
    }
}

