/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.bytes;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class ByteFieldDataComparator
extends NumericFieldDataComparator {
    private final byte[] values;
    private short bottom;

    public ByteFieldDataComparator(int numHits, String fieldName, FieldDataCache fieldDataCache) {
        super(fieldName, fieldDataCache);
        this.values = new byte[numHits];
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.BYTE;
    }

    public int compare(int slot1, int slot2) {
        return this.values[slot1] - this.values[slot2];
    }

    public int compareBottom(int doc) {
        return this.bottom - this.currentFieldData.shortValue(doc);
    }

    public void copy(int slot, int doc) {
        this.values[slot] = this.currentFieldData.byteValue(doc);
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Byte.valueOf(this.values[slot]);
    }
}

